/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.jackson;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.json.UTF8StreamJsonParser;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.serde.exceptions.InvalidFormatException;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.AbstractChildReuseStreamDecoder;
import io.micronaut.serde.support.AbstractStreamDecoder;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

@Internal
final class SpecializedJacksonDecoder
extends AbstractChildReuseStreamDecoder {
    private final UTF8StreamJsonParser parser;

    private SpecializedJacksonDecoder(@NonNull SpecializedJacksonDecoder parent) {
        super((AbstractStreamDecoder)parent);
        this.parser = parent.parser;
    }

    SpecializedJacksonDecoder(UTF8StreamJsonParser parser, @NonNull Class<?> view) {
        super(view);
        this.parser = parser;
    }

    public IOException createDeserializationException(String message, Object invalidValue) {
        if (invalidValue != null) {
            return new InvalidFormatException(message + " \n at " + this.parser.getCurrentLocation(), null, invalidValue);
        }
        return new SerdeException(message + " \n at " + this.parser.getCurrentLocation());
    }

    protected AbstractStreamDecoder.TokenType currentToken() {
        switch (this.parser.currentToken()) {
            case START_OBJECT: {
                return AbstractStreamDecoder.TokenType.START_OBJECT;
            }
            case END_OBJECT: {
                return AbstractStreamDecoder.TokenType.END_OBJECT;
            }
            case START_ARRAY: {
                return AbstractStreamDecoder.TokenType.START_ARRAY;
            }
            case END_ARRAY: {
                return AbstractStreamDecoder.TokenType.END_ARRAY;
            }
            case FIELD_NAME: {
                return AbstractStreamDecoder.TokenType.KEY;
            }
            case VALUE_STRING: {
                return AbstractStreamDecoder.TokenType.STRING;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return AbstractStreamDecoder.TokenType.NUMBER;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return AbstractStreamDecoder.TokenType.BOOLEAN;
            }
            case VALUE_NULL: {
                return AbstractStreamDecoder.TokenType.NULL;
            }
        }
        return AbstractStreamDecoder.TokenType.OTHER;
    }

    protected void nextToken() throws IOException {
        this.parser.nextToken();
    }

    protected String getCurrentKey() throws IOException {
        return this.parser.getCurrentName();
    }

    protected AbstractStreamDecoder createChildDecoder() {
        return new SpecializedJacksonDecoder(this);
    }

    protected String coerceScalarToString() throws IOException {
        return this.parser.getValueAsString();
    }

    protected boolean getBoolean() throws IOException {
        return this.parser.getBooleanValue();
    }

    protected long getLong() throws IOException {
        return this.parser.getValueAsLong();
    }

    protected int getInteger() throws IOException {
        return this.parser.getValueAsInt();
    }

    protected double getDouble() throws IOException {
        if (this.parser.currentToken() == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.parser.getDoubleValue();
        }
        return this.parser.getValueAsDouble();
    }

    protected BigInteger getBigInteger() throws IOException {
        return this.parser.getBigIntegerValue();
    }

    protected BigDecimal getBigDecimal() throws IOException {
        return this.parser.getDecimalValue();
    }

    protected Number getBestNumber() throws IOException {
        return this.parser.getNumberValue();
    }

    protected void skipChildren() throws IOException {
        this.parser.skipChildren();
    }
}

