/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.jackson.core.parser.JacksonCoreParserFactory;
import io.micronaut.jackson.core.parser.JacksonCoreProcessor;
import io.micronaut.jackson.core.tree.JsonNodeTreeCodec;
import io.micronaut.jackson.core.tree.TreeGenerator;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.JsonStreamConfig;
import io.micronaut.json.JsonSyntaxException;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectMapper;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.UpdatingDeserializer;
import io.micronaut.serde.jackson.JacksonDecoder;
import io.micronaut.serde.jackson.JacksonEncoder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.function.Consumer;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;

@Internal
@Singleton
@Primary
@BootstrapContextCompatible
public final class JacksonJsonMapper
implements ObjectMapper {
    private static final JsonFactory FACTORY = new JsonFactory();
    private final SerdeRegistry registry;
    private final JsonStreamConfig deserializationConfig;
    private final JsonNodeTreeCodec treeCodec;
    private final ObjectCodecImpl objectCodecImpl = new ObjectCodecImpl();
    private final Serializer.EncoderContext encoderContext;
    private final Deserializer.DecoderContext decoderContext;

    private JacksonJsonMapper(@NonNull SerdeRegistry registry, @NonNull JsonStreamConfig deserializationConfig, @Nullable Class<?> view) {
        this.registry = registry;
        this.deserializationConfig = deserializationConfig;
        this.treeCodec = JsonNodeTreeCodec.getInstance().withConfig(deserializationConfig);
        this.encoderContext = registry.newEncoderContext(view);
        this.decoderContext = registry.newDecoderContext(view);
    }

    @Inject
    @Internal
    public JacksonJsonMapper(SerdeRegistry registry) {
        this(registry, JsonStreamConfig.DEFAULT, Object.class);
    }

    private void writeValue0(JsonGenerator gen, Object value) throws IOException {
        this.writeValue0(gen, value, value.getClass());
    }

    private <T> void writeValue0(JsonGenerator gen, T value, Class<T> type) throws IOException {
        Argument argument = Argument.of(type);
        this.writeValue(gen, value, argument);
    }

    private <T> void writeValue(JsonGenerator gen, T value, Argument<T> argument) throws IOException {
        gen.setCodec((ObjectCodec)this.objectCodecImpl);
        Serializer serializer = this.encoderContext.findSerializer(argument).createSpecific(this.encoderContext, argument);
        Encoder encoder = JacksonEncoder.create(gen);
        serializer.serialize(encoder, this.encoderContext, argument, value);
    }

    private <T> T readValue(JsonParser parser, Argument<T> type) throws IOException {
        return this.readValue0(parser, type);
    }

    private <T> T readValue0(JsonParser parser, Argument<?> type) throws IOException {
        parser.setCodec((ObjectCodec)this.objectCodecImpl);
        Deserializer deserializer = this.decoderContext.findDeserializer(type).createSpecific(this.decoderContext, type);
        Decoder decoder = JacksonDecoder.create(parser);
        return (T)deserializer.deserializeNullable(decoder, this.decoderContext, type);
    }

    public <T> T readValueFromTree(@NonNull JsonNode tree, @NonNull Argument<T> type) throws IOException {
        return this.readValue(this.treeCodec.treeAsTokens(tree), type);
    }

    @NonNull
    public JsonNode writeValueToTree(@Nullable Object value) throws IOException {
        TreeGenerator treeGenerator = this.treeCodec.createTreeGenerator();
        this.writeValue0((JsonGenerator)treeGenerator, value);
        return treeGenerator.getCompletedValue();
    }

    public <T> JsonNode writeValueToTree(Argument<T> type, T value) throws IOException {
        TreeGenerator treeGenerator = this.treeCodec.createTreeGenerator();
        this.writeValue((JsonGenerator)treeGenerator, value, type);
        return treeGenerator.getCompletedValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T readValue(@NonNull InputStream inputStream, @NonNull Argument<T> type) throws IOException {
        try (JsonParser parser = FACTORY.createParser(inputStream);){
            T t = this.readValue(parser, type);
            return t;
        }
        catch (JsonParseException pe) {
            throw new JsonSyntaxException((Throwable)pe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T readValue(@NonNull byte[] byteArray, @NonNull Argument<T> type) throws IOException {
        try (JsonParser parser = FACTORY.createParser(byteArray);){
            T t = this.readValue(parser, type);
            return t;
        }
        catch (JsonParseException pe) {
            throw new JsonSyntaxException((Throwable)pe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T readValue(@NonNull ByteBuffer<?> byteBuffer, @NonNull Argument<T> type) throws IOException {
        try (JsonParser parser = JacksonCoreParserFactory.createJsonParser((JsonFactory)FACTORY, byteBuffer);){
            T t = this.readValue(parser, type);
            return t;
        }
        catch (JsonParseException pe) {
            throw new JsonSyntaxException((Throwable)pe);
        }
    }

    public void writeValue(@NonNull OutputStream outputStream, @Nullable Object object) throws IOException {
        try (JsonGenerator generator = FACTORY.createGenerator(outputStream);){
            this.writeValue0(generator, object);
        }
    }

    public <T> void writeValue(OutputStream outputStream, Argument<T> type, T object) throws IOException {
        try (JsonGenerator generator = FACTORY.createGenerator(outputStream);){
            this.writeValue(generator, object, type);
        }
    }

    public byte[] writeValueAsBytes(@Nullable Object object) throws IOException {
        ByteArrayBuilder bb = new ByteArrayBuilder(FACTORY._getBufferRecycler());
        try (JsonGenerator generator = FACTORY.createGenerator((OutputStream)bb);){
            this.writeValue0(generator, object);
        }
        byte[] bytes = bb.toByteArray();
        bb.release();
        return bytes;
    }

    public <T> byte[] writeValueAsBytes(Argument<T> type, T object) throws IOException {
        ByteArrayBuilder bb = new ByteArrayBuilder(FACTORY._getBufferRecycler());
        try (JsonGenerator generator = FACTORY.createGenerator((OutputStream)bb);){
            this.writeValue(generator, object, type);
        }
        byte[] bytes = bb.toByteArray();
        bb.release();
        return bytes;
    }

    @NonNull
    public JsonStreamConfig getStreamConfig() {
        return this.deserializationConfig;
    }

    @NonNull
    public Processor<byte[], JsonNode> createReactiveParser(final Consumer<Processor<byte[], JsonNode>> onSubscribe, boolean streamArray) {
        return new JacksonCoreProcessor(streamArray, new JsonFactory(), this.deserializationConfig){

            public void subscribe(Subscriber<? super JsonNode> downstreamSubscriber) {
                onSubscribe.accept(this);
                super.subscribe(downstreamSubscriber);
            }
        };
    }

    @NonNull
    public JsonMapper cloneWithViewClass(@NonNull Class<?> viewClass) {
        return new JacksonJsonMapper(this.registry, this.deserializationConfig, viewClass);
    }

    public void updateValueFromTree(Object value, JsonNode tree) throws IOException {
        Argument type;
        Deserializer deserializer;
        if (tree != null && value != null && (deserializer = this.decoderContext.findDeserializer(type = Argument.of(value.getClass())).createSpecific(this.decoderContext, type)) instanceof UpdatingDeserializer) {
            try (JsonParser parser = this.treeCodec.treeAsTokens(tree);){
                parser.setCodec((ObjectCodec)this.objectCodecImpl);
                if (!parser.hasCurrentToken()) {
                    parser.nextToken();
                }
                if (parser.currentToken() != JsonToken.VALUE_NULL) {
                    Decoder decoder = JacksonDecoder.create(parser);
                    ((UpdatingDeserializer)deserializer).deserializeInto(decoder, this.decoderContext, type, value);
                }
            }
        }
    }

    private class ObjectCodecImpl
    extends ObjectCodec {
        private ObjectCodecImpl() {
        }

        public Version version() {
            return Version.unknownVersion();
        }

        public <T> T readValue(JsonParser p, Class<T> valueType) throws IOException {
            return JacksonJsonMapper.this.readValue0(p, Argument.of(valueType));
        }

        public <T> T readValue(JsonParser p, TypeReference<T> valueTypeRef) throws IOException {
            return JacksonJsonMapper.this.readValue0(p, Argument.of((Type)valueTypeRef.getType()));
        }

        public <T> T readValue(JsonParser p, ResolvedType valueType) throws IOException {
            throw new UnsupportedOperationException();
        }

        public <T> Iterator<T> readValues(JsonParser p, Class<T> valueType) throws IOException {
            throw new UnsupportedOperationException();
        }

        public <T> Iterator<T> readValues(JsonParser p, TypeReference<T> valueTypeRef) throws IOException {
            throw new UnsupportedOperationException();
        }

        public <T> Iterator<T> readValues(JsonParser p, ResolvedType valueType) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void writeValue(JsonGenerator gen, Object value) throws IOException {
            JacksonJsonMapper.this.writeValue0(gen, value);
        }

        public <T extends TreeNode> T readTree(JsonParser p) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void writeTree(JsonGenerator gen, TreeNode tree) throws IOException {
            throw new UnsupportedOperationException();
        }

        public TreeNode createObjectNode() {
            throw new UnsupportedOperationException();
        }

        public TreeNode createArrayNode() {
            throw new UnsupportedOperationException();
        }

        public JsonParser treeAsTokens(TreeNode n) {
            throw new UnsupportedOperationException();
        }

        public <T> T treeToValue(TreeNode n, Class<T> valueType) throws JsonProcessingException {
            throw new UnsupportedOperationException();
        }
    }
}

