/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.oracle.jdbc.json;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Order;
import io.micronaut.json.JsonMapper;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.oracle.jdbc.json.AbstractOracleJdbcJsonObjectMapper;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonParser;

@Singleton
@BootstrapContextCompatible
@Order(value=200)
public final class OracleJdbcJsonBinaryObjectMapper
extends AbstractOracleJdbcJsonObjectMapper {
    public OracleJdbcJsonBinaryObjectMapper(SerdeRegistry registry) {
        super(registry);
    }

    public OracleJdbcJsonBinaryObjectMapper(SerdeRegistry registry, Class<?> view) {
        super(registry, view);
    }

    public JsonMapper cloneWithViewClass(Class<?> viewClass) {
        return new OracleJdbcJsonBinaryObjectMapper(this.registry, viewClass);
    }

    @Override
    OracleJsonParser getJsonParser(InputStream inputStream) {
        return this.oracleJsonFactory.createJsonBinaryParser(inputStream);
    }

    @Override
    OracleJsonGenerator createJsonGenerator(OutputStream outputStream) {
        return this.oracleJsonFactory.createJsonBinaryGenerator(outputStream);
    }
}

