/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.oracle.jdbc.json;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.exceptions.InvalidFormatException;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.AbstractStreamDecoder;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonParser;

@Internal
public final class OracleJdbcJsonParserDecoder
extends AbstractStreamDecoder {
    private static final String METHOD_CALLED_IN_WRONG_CONTEXT = "Method called in wrong context ";
    private final OracleJsonParser jsonParser;
    private OracleJsonParser.Event currentEvent;

    OracleJdbcJsonParserDecoder(OracleJsonParser jsonParser) {
        this.jsonParser = jsonParser;
        this.currentEvent = jsonParser.next();
    }

    public void finishStructure(boolean consumeLeftElements) throws IOException {
        super.finishStructure(consumeLeftElements);
        this.nextToken();
    }

    protected AbstractStreamDecoder.TokenType currentToken() {
        return switch (this.currentEvent) {
            case OracleJsonParser.Event.START_ARRAY -> AbstractStreamDecoder.TokenType.START_ARRAY;
            case OracleJsonParser.Event.START_OBJECT -> AbstractStreamDecoder.TokenType.START_OBJECT;
            case OracleJsonParser.Event.KEY_NAME -> AbstractStreamDecoder.TokenType.KEY;
            case OracleJsonParser.Event.VALUE_STRING -> AbstractStreamDecoder.TokenType.STRING;
            case OracleJsonParser.Event.VALUE_DECIMAL, OracleJsonParser.Event.VALUE_DOUBLE, OracleJsonParser.Event.VALUE_FLOAT -> AbstractStreamDecoder.TokenType.NUMBER;
            case OracleJsonParser.Event.VALUE_TRUE, OracleJsonParser.Event.VALUE_FALSE -> AbstractStreamDecoder.TokenType.BOOLEAN;
            case OracleJsonParser.Event.VALUE_NULL -> AbstractStreamDecoder.TokenType.NULL;
            case OracleJsonParser.Event.END_OBJECT -> AbstractStreamDecoder.TokenType.END_OBJECT;
            case OracleJsonParser.Event.END_ARRAY -> AbstractStreamDecoder.TokenType.END_ARRAY;
            default -> AbstractStreamDecoder.TokenType.OTHER;
        };
    }

    protected void nextToken() {
        this.currentEvent = this.jsonParser.hasNext() ? this.jsonParser.next() : null;
    }

    protected String getCurrentKey() {
        return this.jsonParser.getString();
    }

    protected String coerceScalarToString(AbstractStreamDecoder.TokenType currentToken) {
        return switch (this.currentEvent) {
            case OracleJsonParser.Event.VALUE_STRING, OracleJsonParser.Event.VALUE_DECIMAL, OracleJsonParser.Event.VALUE_DOUBLE, OracleJsonParser.Event.VALUE_FLOAT, OracleJsonParser.Event.VALUE_INTERVALDS, OracleJsonParser.Event.VALUE_INTERVALYM -> this.jsonParser.getString();
            case OracleJsonParser.Event.VALUE_BINARY -> this.jsonParser.getValue().asJsonBinary().getString();
            case OracleJsonParser.Event.VALUE_TRUE -> "true";
            case OracleJsonParser.Event.VALUE_FALSE -> "false";
            default -> throw new IllegalStateException(METHOD_CALLED_IN_WRONG_CONTEXT + this.currentEvent);
        };
    }

    protected boolean getBoolean() {
        return this.currentEvent == OracleJsonParser.Event.VALUE_TRUE;
    }

    protected String getString() {
        return this.jsonParser.getString();
    }

    protected long getLong() {
        return this.jsonParser.getLong();
    }

    protected double getDouble() {
        return this.jsonParser.getBigDecimal().doubleValue();
    }

    protected BigInteger getBigInteger() {
        return this.jsonParser.getBigDecimal().toBigInteger();
    }

    protected BigDecimal getBigDecimal() {
        return this.jsonParser.getBigDecimal();
    }

    protected Number getBestNumber() {
        return switch (this.currentEvent) {
            case OracleJsonParser.Event.VALUE_DECIMAL -> this.jsonParser.getLong();
            case OracleJsonParser.Event.VALUE_DOUBLE -> this.jsonParser.getDouble();
            case OracleJsonParser.Event.VALUE_FLOAT -> Float.valueOf(this.jsonParser.getFloat());
            default -> throw new IllegalStateException(METHOD_CALLED_IN_WRONG_CONTEXT + this.currentEvent);
        };
    }

    protected void skipChildren() {
        if (this.currentEvent == OracleJsonParser.Event.START_OBJECT) {
            this.jsonParser.skipObject();
        } else if (this.currentEvent == OracleJsonParser.Event.START_ARRAY) {
            this.jsonParser.skipArray();
        }
    }

    @NonNull
    public IOException createDeserializationException(@NonNull String message, @Nullable Object invalidValue) {
        if (invalidValue != null) {
            return new InvalidFormatException(message, null, invalidValue);
        }
        return new SerdeException(message);
    }

    public byte[] decodeBinary() {
        if (this.currentEvent == OracleJsonParser.Event.VALUE_BINARY) {
            byte[] bytes = this.jsonParser.getBytes();
            this.nextToken();
            return bytes;
        }
        if (this.currentEvent == OracleJsonParser.Event.START_ARRAY) {
            OracleJsonArray oracleJsonArray = this.jsonParser.getArray();
            int size = oracleJsonArray.size();
            byte[] bytes = new byte[size];
            for (int i = 0; i < size; ++i) {
                bytes[i] = oracleJsonArray.isNull(i) ? (byte)0 : (byte)oracleJsonArray.getInt(i);
            }
            this.nextToken();
            return bytes;
        }
        if (this.currentEvent == OracleJsonParser.Event.VALUE_STRING) {
            String str = this.jsonParser.getString();
            this.nextToken();
            return OracleJdbcJsonParserDecoder.decodeBase16(str);
        }
        throw new IllegalStateException(METHOD_CALLED_IN_WRONG_CONTEXT + this.currentEvent);
    }

    public LocalDateTime decodeLocalDateTime() {
        LocalDateTime value = switch (this.currentEvent) {
            case OracleJsonParser.Event.VALUE_DATE, OracleJsonParser.Event.VALUE_TIMESTAMP -> this.jsonParser.getLocalDateTime();
            case OracleJsonParser.Event.VALUE_STRING -> LocalDateTime.parse(this.jsonParser.getString());
            default -> throw new IllegalStateException(METHOD_CALLED_IN_WRONG_CONTEXT + this.currentEvent);
        };
        this.nextToken();
        return value;
    }

    public OffsetDateTime decodeOffsetDateTime() {
        OffsetDateTime value = switch (this.currentEvent) {
            case OracleJsonParser.Event.VALUE_TIMESTAMPTZ -> this.jsonParser.getOffsetDateTime();
            case OracleJsonParser.Event.VALUE_STRING -> OffsetDateTime.parse(this.jsonParser.getString());
            default -> throw new IllegalStateException(METHOD_CALLED_IN_WRONG_CONTEXT + this.currentEvent);
        };
        this.nextToken();
        return value;
    }

    public ZonedDateTime decodeZonedDateTime() {
        ZonedDateTime value = switch (this.currentEvent) {
            case OracleJsonParser.Event.VALUE_TIMESTAMPTZ -> this.jsonParser.getOffsetDateTime().toZonedDateTime();
            case OracleJsonParser.Event.VALUE_STRING -> ZonedDateTime.parse(this.jsonParser.getString());
            default -> throw new IllegalStateException(METHOD_CALLED_IN_WRONG_CONTEXT + this.currentEvent);
        };
        this.nextToken();
        return value;
    }

    private static byte[] decodeBase16(CharSequence cs) {
        int len = cs.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Encoded string must have an even length");
        }
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int lo;
            int hi = Character.digit(cs.charAt(i), 16);
            if ((hi | (lo = Character.digit(cs.charAt(i + 1), 16))) < 0) {
                throw new IllegalArgumentException("Encoded string " + cs + " contains non-hex characters");
            }
            bytes[i / 2] = (byte)(hi << 4 | lo);
        }
        return bytes;
    }
}

