/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.oracle.jdbc.json;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Order;
import io.micronaut.json.JsonMapper;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.oracle.jdbc.json.AbstractOracleJdbcJsonObjectMapper;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonParser;

@Singleton
@BootstrapContextCompatible
@Order(value=199)
public final class OracleJdbcJsonTextObjectMapper
extends AbstractOracleJdbcJsonObjectMapper {
    public OracleJdbcJsonTextObjectMapper(SerdeRegistry registry) {
        super(registry);
    }

    public OracleJdbcJsonTextObjectMapper(SerdeRegistry registry, Class<?> view) {
        super(registry, view);
    }

    public JsonMapper cloneWithViewClass(Class<?> viewClass) {
        return new OracleJdbcJsonTextObjectMapper(this.registry, viewClass);
    }

    @Override
    OracleJsonParser getJsonParser(InputStream inputStream) {
        return this.oracleJsonFactory.createJsonTextParser(inputStream);
    }

    @Override
    OracleJsonGenerator createJsonGenerator(OutputStream outputStream) {
        return this.oracleJsonFactory.createJsonTextGenerator(outputStream);
    }
}

