/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.oracle.jdbc.json;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import oracle.sql.json.OracleJsonGenerator;

@Internal
public final class OracleJdbcJsonGeneratorEncoder
implements Encoder {
    private final OracleJsonGenerator jsonGenerator;
    private final OracleJdbcJsonGeneratorEncoder parent;
    private String currentKey;
    private int currentIndex;

    OracleJdbcJsonGeneratorEncoder(OracleJsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
        this.parent = null;
    }

    OracleJdbcJsonGeneratorEncoder(OracleJdbcJsonGeneratorEncoder parent) {
        this.jsonGenerator = parent.jsonGenerator;
        this.parent = parent;
    }

    private void postEncodeValue() {
        ++this.currentIndex;
    }

    public Encoder encodeArray(Argument<?> type) {
        this.jsonGenerator.writeStartArray();
        return new OracleJdbcJsonGeneratorEncoder(this);
    }

    public Encoder encodeObject(Argument<?> type) {
        this.jsonGenerator.writeStartObject();
        return new OracleJdbcJsonGeneratorEncoder(this);
    }

    public void finishStructure() {
        if (this.parent == null) {
            throw new IllegalStateException("Not a structure");
        }
        this.jsonGenerator.writeEnd();
        this.parent.postEncodeValue();
    }

    public void encodeKey(String key) {
        this.jsonGenerator.writeKey(key);
        this.currentKey = key;
    }

    public void encodeString(String value) {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeBoolean(boolean value) {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeByte(byte value) {
        this.jsonGenerator.write((int)value);
        this.postEncodeValue();
    }

    public void encodeShort(short value) {
        this.jsonGenerator.write((int)value);
        this.postEncodeValue();
    }

    public void encodeChar(char value) {
        this.jsonGenerator.write((int)value);
        this.postEncodeValue();
    }

    public void encodeInt(int value) {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeLong(long value) {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeFloat(float value) {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeDouble(double value) {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeBigInteger(BigInteger value) {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeBigDecimal(BigDecimal value) {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeNull() {
        this.jsonGenerator.writeNull();
        this.postEncodeValue();
    }

    @NonNull
    public String currentPath() {
        StringBuilder builder = new StringBuilder();
        OracleJdbcJsonGeneratorEncoder enc = this;
        while (enc != null) {
            if (enc != this) {
                builder.insert(0, "->");
            }
            if (enc.currentKey == null) {
                if (enc.parent != null) {
                    builder.insert(0, enc.currentIndex);
                }
            } else {
                builder.insert(0, enc.currentKey);
            }
            enc = enc.parent;
        }
        return builder.toString();
    }

    public void encodeLocalDateTime(LocalDateTime localDateTime) {
        this.jsonGenerator.write(localDateTime.toString());
        this.postEncodeValue();
    }

    public void encodeOffsetDateTime(OffsetDateTime offsetDateTime) {
        this.jsonGenerator.write(offsetDateTime.toString());
        this.postEncodeValue();
    }
}

