/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.oracle.jdbc.json.serde;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonGeneratorEncoder;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonParserDecoder;
import io.micronaut.serde.oracle.jdbc.json.serde.AbstractOracleJsonSerde;
import io.micronaut.serde.support.DefaultSerdeRegistry;
import jakarta.inject.Singleton;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;

@Singleton
@Order(value=-100)
public class OracleJsonBinarySerde
extends AbstractOracleJsonSerde<byte[]> {
    @Override
    @NonNull
    protected byte[] doDeserializeNonNull(@NonNull OracleJdbcJsonParserDecoder decoder, @NonNull Deserializer.DecoderContext decoderContext, @NonNull Argument<? super byte[]> type) {
        return decoder.decodeBinary();
    }

    @Override
    protected void doSerializeNonNull(@NonNull OracleJdbcJsonGeneratorEncoder encoder, @NonNull Serializer.EncoderContext context, @NonNull Argument<? extends byte[]> type, @NonNull byte[] value) {
        encoder.encodeString(OracleJsonBinaryImpl.getString((byte[])value, (boolean)false));
    }

    @Override
    protected Serde<byte[]> getDefault() {
        return DefaultSerdeRegistry.BYTE_ARRAY_SERDE;
    }
}

