/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.oracle.jdbc.json.serde;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonGeneratorEncoder;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonParserDecoder;
import java.io.IOException;

@Internal
public abstract class AbstractOracleJsonSerde<T>
implements Serde<T> {
    @NonNull
    public final T deserialize(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext decoderContext, @NonNull Argument<? super T> type) throws IOException {
        if (decoder instanceof OracleJdbcJsonParserDecoder) {
            OracleJdbcJsonParserDecoder oracleJdbcJsonParserDecoder = (OracleJdbcJsonParserDecoder)decoder;
            return this.doDeserializeNonNull(oracleJdbcJsonParserDecoder, decoderContext, type);
        }
        return (T)this.getDefault().deserialize(decoder, decoderContext, type);
    }

    public void serialize(@NonNull Encoder encoder, @NonNull Serializer.EncoderContext context, @NonNull Argument<? extends T> type, T value) throws IOException {
        if (encoder instanceof OracleJdbcJsonGeneratorEncoder) {
            OracleJdbcJsonGeneratorEncoder oracleEncoder = (OracleJdbcJsonGeneratorEncoder)encoder;
            if (value == null) {
                encoder.encodeNull();
            } else {
                this.doSerializeNonNull(oracleEncoder, context, type, value);
            }
        } else {
            this.getDefault().serialize(encoder, context, type, value);
        }
    }

    @NonNull
    protected abstract T doDeserializeNonNull(@NonNull OracleJdbcJsonParserDecoder var1, @NonNull Deserializer.DecoderContext var2, @NonNull Argument<? super T> var3) throws IOException;

    protected abstract void doSerializeNonNull(OracleJdbcJsonGeneratorEncoder var1, Serializer.EncoderContext var2, Argument<? extends T> var3, @NonNull T var4) throws IOException;

    protected abstract Serde<T> getDefault();
}

