/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.oracle.jdbc.json.serde;

import io.micronaut.core.annotation.Order;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonGeneratorEncoder;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonParserDecoder;
import io.micronaut.serde.oracle.jdbc.json.serde.AbstractOracleJsonSerde;
import io.micronaut.serde.support.serdes.LocalDateTimeSerde;
import jakarta.inject.Singleton;
import java.time.LocalDateTime;

@Singleton
@Order(value=-100)
public class OracleJsonLocaleDateTimeSerde
extends AbstractOracleJsonSerde<LocalDateTime> {
    private final LocalDateTimeSerde dateTimeSerde;

    public OracleJsonLocaleDateTimeSerde(LocalDateTimeSerde dateTimeSerde) {
        this.dateTimeSerde = dateTimeSerde;
    }

    @Override
    protected LocalDateTime doDeserializeNonNull(OracleJdbcJsonParserDecoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super LocalDateTime> type) {
        return decoder.decodeLocalDateTime();
    }

    @Override
    protected void doSerializeNonNull(OracleJdbcJsonGeneratorEncoder encoder, Serializer.EncoderContext context, Argument<? extends LocalDateTime> type, LocalDateTime value) {
        encoder.encodeLocalDateTime(value);
    }

    @Override
    protected Serde<LocalDateTime> getDefault() {
        return this.dateTimeSerde;
    }
}

