/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.oracle.jdbc.json.serde;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonGeneratorEncoder;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonParserDecoder;
import io.micronaut.serde.oracle.jdbc.json.serde.AbstractOracleJsonSerde;
import io.micronaut.serde.support.serdes.LocalTimeSerde;
import jakarta.inject.Singleton;
import java.time.LocalDate;
import java.time.LocalTime;

@Singleton
@Order(value=-100)
public class OracleJsonLocaleTimeSerde
extends AbstractOracleJsonSerde<LocalTime> {
    private final LocalTimeSerde localTimeSerde;

    public OracleJsonLocaleTimeSerde(LocalTimeSerde localTimeSerde) {
        this.localTimeSerde = localTimeSerde;
    }

    @Override
    @NonNull
    protected LocalTime doDeserializeNonNull(@NonNull OracleJdbcJsonParserDecoder decoder, @NonNull Deserializer.DecoderContext decoderContext, @NonNull Argument<? super LocalTime> type) {
        return decoder.decodeLocalDateTime().toLocalTime();
    }

    @Override
    protected void doSerializeNonNull(OracleJdbcJsonGeneratorEncoder encoder, Serializer.EncoderContext context, Argument<? extends LocalTime> type, LocalTime value) {
        encoder.encodeLocalDateTime(value.atDate(LocalDate.now()));
    }

    @Override
    protected Serde<LocalTime> getDefault() {
        return this.localTimeSerde;
    }
}

