/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.oracle.jdbc.json.serde;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.Duration;

@Singleton
@Order(value=-100)
public class OracleJsonDurationSerde
implements Serde<Duration> {
    @NonNull
    public Duration deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Duration> type) throws IOException {
        String duration = decoder.decodeString();
        return Duration.parse(duration);
    }

    public void serialize(@NonNull Encoder encoder, @NonNull Serializer.EncoderContext context, @NonNull Argument<? extends Duration> type, Duration value) throws IOException {
        if (value == null) {
            encoder.encodeNull();
        } else {
            encoder.encodeString(value.toString());
        }
    }
}

