/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.oracle.jdbc.json.serde;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonGeneratorEncoder;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonParserDecoder;
import io.micronaut.serde.oracle.jdbc.json.serde.AbstractOracleJsonSerde;
import io.micronaut.serde.support.serdes.LocalDateSerde;
import jakarta.inject.Singleton;
import java.time.LocalDate;

@Singleton
@Order(value=-100)
public class OracleJsonLocaleDateSerde
extends AbstractOracleJsonSerde<LocalDate> {
    private final LocalDateSerde localDateSerde;

    public OracleJsonLocaleDateSerde(LocalDateSerde localDateSerde) {
        this.localDateSerde = localDateSerde;
    }

    @Override
    @NonNull
    protected LocalDate doDeserializeNonNull(@NonNull OracleJdbcJsonParserDecoder decoder, @NonNull Deserializer.DecoderContext decoderContext, @NonNull Argument<? super LocalDate> type) {
        return decoder.decodeLocalDateTime().toLocalDate();
    }

    @Override
    protected void doSerializeNonNull(OracleJdbcJsonGeneratorEncoder encoder, Serializer.EncoderContext context, Argument<? extends LocalDate> type, LocalDate value) {
        encoder.encodeLocalDateTime(value.atStartOfDay());
    }

    @Override
    protected Serde<LocalDate> getDefault() {
        return this.localDateSerde;
    }
}

