/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.oracle.jdbc.json;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.json.JsonStreamConfig;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.ObjectMapper;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonGeneratorEncoder;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonParserDecoder;
import io.micronaut.serde.support.util.BufferingJsonNodeProcessor;
import io.micronaut.serde.support.util.JsonNodeDecoder;
import io.micronaut.serde.support.util.JsonNodeEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Consumer;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonValue;
import org.reactivestreams.Processor;

@Internal
abstract class AbstractOracleJdbcJsonObjectMapper
implements ObjectMapper {
    protected final SerdeRegistry registry;
    @Nullable
    protected final SerdeConfiguration serdeConfiguration;
    protected final Class<?> view;
    protected final OracleJsonFactory oracleJsonFactory = new OracleJsonFactory();

    protected AbstractOracleJdbcJsonObjectMapper(SerdeRegistry registry, SerdeConfiguration serdeConfiguration) {
        this.registry = registry;
        this.serdeConfiguration = serdeConfiguration;
        this.view = null;
    }

    protected AbstractOracleJdbcJsonObjectMapper(SerdeRegistry registry, SerdeConfiguration serdeConfiguration, Class<?> view) {
        this.registry = registry;
        this.serdeConfiguration = serdeConfiguration;
        this.view = view;
    }

    abstract OracleJsonParser getJsonParser(InputStream var1);

    abstract OracleJsonGenerator createJsonGenerator(OutputStream var1);

    public <T> T readValueFromTree(JsonNode tree, Argument<T> type) throws IOException {
        Deserializer.DecoderContext context = this.registry.newDecoderContext(this.view);
        Deserializer deserializer = this.registry.findDeserializer(type).createSpecific(context, type);
        return (T)deserializer.deserialize((Decoder)JsonNodeDecoder.create((JsonNode)tree, (LimitingStream.RemainingLimits)this.limits()), context, type);
    }

    public <T> T readValue(InputStream inputStream, Argument<T> type) throws IOException {
        try (OracleJsonParser parser = this.getJsonParser(inputStream);){
            T t = this.readValue(parser, type);
            return t;
        }
    }

    public <T> T readValue(byte[] byteArray, Argument<T> type) throws IOException {
        try (OracleJsonParser parser = this.getJsonParser(new ByteArrayInputStream(byteArray));){
            T t = this.readValue(parser, type);
            return t;
        }
    }

    @NonNull
    public <T> T readValue(@NonNull OracleJsonParser parser, @NonNull Argument<T> type) throws IOException {
        if (type.getType() == OracleJsonObject.class) {
            OracleJsonParser.Event event = parser.next();
            if (event != OracleJsonParser.Event.START_OBJECT) {
                throw new SerdeException("Invalid state: " + event);
            }
            return (T)parser.getObject();
        }
        if (type.getType() == OracleJsonArray.class) {
            OracleJsonParser.Event event = parser.next();
            if (event != OracleJsonParser.Event.START_ARRAY) {
                throw new SerdeException("Invalid state: " + event);
            }
            return (T)parser.getArray();
        }
        Deserializer.DecoderContext context = this.registry.newDecoderContext(this.view);
        Deserializer deserializer = this.registry.findDeserializer(type).createSpecific(context, type);
        return (T)deserializer.deserialize((Decoder)new OracleJdbcJsonParserDecoder(parser, this.limits()), context, type);
    }

    public Processor<byte[], JsonNode> createReactiveParser(Consumer<Processor<byte[], JsonNode>> onSubscribe, boolean streamArray) {
        return new BufferingJsonNodeProcessor(onSubscribe, streamArray){

            @NonNull
            protected JsonNode parseOne(@NonNull InputStream is) throws IOException {
                try (OracleJsonParser parser = AbstractOracleJdbcJsonObjectMapper.this.getJsonParser(is);){
                    OracleJdbcJsonParserDecoder decoder = new OracleJdbcJsonParserDecoder(parser, AbstractOracleJdbcJsonObjectMapper.this.limits());
                    Object o = decoder.decodeArbitrary();
                    JsonNode jsonNode = AbstractOracleJdbcJsonObjectMapper.this.writeValueToTree(o);
                    return jsonNode;
                }
            }
        };
    }

    @NonNull
    private LimitingStream.RemainingLimits limits() {
        return this.serdeConfiguration == null ? LimitingStream.DEFAULT_LIMITS : LimitingStream.limitsFromConfiguration((SerdeConfiguration)this.serdeConfiguration);
    }

    public JsonNode writeValueToTree(Object value) throws IOException {
        JsonNodeEncoder encoder = JsonNodeEncoder.create((LimitingStream.RemainingLimits)this.limits());
        this.serialize((Encoder)encoder, value);
        return encoder.getCompletedValue();
    }

    public <T> JsonNode writeValueToTree(Argument<T> type, T value) throws IOException {
        JsonNodeEncoder encoder = JsonNodeEncoder.create((LimitingStream.RemainingLimits)this.limits());
        this.serialize((Encoder)encoder, value, type);
        return encoder.getCompletedValue();
    }

    public void writeValue(OutputStream outputStream, Object object) throws IOException {
        try (OracleJsonGenerator generator = this.createJsonGenerator(Objects.requireNonNull(outputStream, "Output stream cannot be null"));){
            if (object instanceof OracleJsonObject) {
                generator.write((OracleJsonValue)((OracleJsonObject)object));
            } else if (object instanceof OracleJsonArray) {
                generator.write((OracleJsonValue)((OracleJsonArray)object));
            } else if (object == null) {
                generator.writeNull();
            } else {
                OracleJdbcJsonGeneratorEncoder encoder = new OracleJdbcJsonGeneratorEncoder(generator, this.limits());
                this.serialize(encoder, object);
            }
            generator.flush();
        }
    }

    public <T> void writeValue(OutputStream outputStream, Argument<T> type, T object) throws IOException {
        try (OracleJsonGenerator generator = this.createJsonGenerator(Objects.requireNonNull(outputStream, "Output stream cannot be null"));){
            this.writeValue(generator, object, type);
        }
    }

    public <T> void writeValue(@NonNull OracleJsonGenerator generator, @NonNull T value, @NonNull Argument<T> type) throws IOException {
        if (value == null) {
            generator.writeNull();
        } else {
            OracleJdbcJsonGeneratorEncoder encoder = new OracleJdbcJsonGeneratorEncoder(generator, this.limits());
            this.serialize(encoder, value, type);
        }
        generator.flush();
    }

    private void serialize(Encoder encoder, Object object) throws IOException {
        this.serialize(encoder, object, Argument.of(object.getClass()));
    }

    private void serialize(Encoder encoder, Object object, Argument type) throws IOException {
        Serializer.EncoderContext context = this.registry.newEncoderContext(this.view);
        Serializer serializer = this.registry.findSerializer(type).createSpecific(context, type);
        serializer.serialize(encoder, context, type, object);
    }

    public byte[] writeValueAsBytes(Object object) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.writeValue(output, object);
        return output.toByteArray();
    }

    public <T> byte[] writeValueAsBytes(Argument<T> type, T object) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.writeValue(output, type, object);
        return output.toByteArray();
    }

    public JsonStreamConfig getStreamConfig() {
        return JsonStreamConfig.DEFAULT;
    }
}

