/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.oracle.jdbc.json.serde;

import io.micronaut.core.annotation.Order;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonGeneratorEncoder;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonParserDecoder;
import io.micronaut.serde.oracle.jdbc.json.serde.AbstractOracleJsonSerde;
import io.micronaut.serde.support.serdes.ZonedDateTimeSerde;
import jakarta.inject.Singleton;
import java.time.ZonedDateTime;

@Singleton
@Order(value=-100)
public class OracleJsonZonedDateTimeSerde
extends AbstractOracleJsonSerde<ZonedDateTime> {
    private final ZonedDateTimeSerde zonedDateTimeSerde;

    public OracleJsonZonedDateTimeSerde(ZonedDateTimeSerde zonedDateTimeSerde) {
        this.zonedDateTimeSerde = zonedDateTimeSerde;
    }

    @Override
    protected ZonedDateTime doDeserializeNonNull(OracleJdbcJsonParserDecoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super ZonedDateTime> type) {
        return decoder.decodeZonedDateTime();
    }

    @Override
    protected void doSerializeNonNull(OracleJdbcJsonGeneratorEncoder encoder, Serializer.EncoderContext context, Argument<? extends ZonedDateTime> type, ZonedDateTime value) {
        encoder.encodeOffsetDateTime(value.toOffsetDateTime());
    }

    @Override
    protected Serde<ZonedDateTime> getDefault() {
        return this.zonedDateTimeSerde;
    }
}

