/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.oracle.jdbc.json.serde;

import io.micronaut.core.annotation.Order;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonGeneratorEncoder;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonParserDecoder;
import io.micronaut.serde.oracle.jdbc.json.serde.AbstractOracleJsonSerde;
import io.micronaut.serde.support.serdes.OffsetDateTimeSerde;
import jakarta.inject.Singleton;
import java.time.OffsetDateTime;

@Singleton
@Order(value=-100)
public class OracleJsonOffsetDateTimeSerde
extends AbstractOracleJsonSerde<OffsetDateTime> {
    private final OffsetDateTimeSerde offsetDateTimeSerde;

    public OracleJsonOffsetDateTimeSerde(OffsetDateTimeSerde offsetDateTimeSerde) {
        this.offsetDateTimeSerde = offsetDateTimeSerde;
    }

    @Override
    protected OffsetDateTime doDeserializeNonNull(OracleJdbcJsonParserDecoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super OffsetDateTime> type) {
        return decoder.decodeOffsetDateTime();
    }

    @Override
    protected void doSerializeNonNull(OracleJdbcJsonGeneratorEncoder encoder, Serializer.EncoderContext context, Argument<? extends OffsetDateTime> type, OffsetDateTime value) {
        encoder.encodeOffsetDateTime(value);
    }

    @Override
    protected Serde<OffsetDateTime> getDefault() {
        return this.offsetDateTimeSerde;
    }
}

