/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.jackson;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.config.annotation.SerdeConfig;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JsonSubTypesMapper
implements NamedAnnotationMapper {
    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        ArrayList<AnnotationValue> subtypes = new ArrayList<AnnotationValue>();
        List annotations = annotation.getAnnotations("value");
        for (AnnotationValue annotationValue : annotations) {
            AnnotationClassValue acv = annotationValue.annotationClassValue("value").orElse(null);
            if (acv == null) continue;
            AnnotationValueBuilder builder = AnnotationValue.builder(SerdeConfig.Subtyped.Subtype.class).member("value", new AnnotationClassValue[]{acv});
            Object[] names = annotationValue.stringValues("names");
            String v = annotationValue.stringValue("name").orElse(null);
            if (v != null) {
                names = (String[])ArrayUtils.concat((Object[])names, (Object[])new String[]{v});
            }
            if (ArrayUtils.isNotEmpty((Object[])names)) {
                builder.member("names", (String[])names);
            }
            subtypes.add(builder.build());
        }
        if (CollectionUtils.isNotEmpty(subtypes)) {
            return Collections.singletonList(AnnotationValue.builder(SerdeConfig.Subtyped.class).values(subtypes.toArray(new AnnotationValue[0])).build());
        }
        return Collections.emptyList();
    }

    public String getName() {
        return "com.fasterxml.jackson.annotation.JsonSubTypes";
    }
}

