/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.jackson;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.config.annotation.SerdeConfig;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public abstract class ValidatingAnnotationMapper
implements NamedAnnotationMapper {
    public final List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        Set<String> supported = this.getSupportedMemberNames();
        Set memberNames = annotation.getMemberNames();
        Optional<CharSequence> unsupportedMember = memberNames.stream().filter(n -> !supported.contains(n.toString())).findFirst();
        return unsupportedMember.map(charSequence -> Collections.singletonList(AnnotationValue.builder(SerdeConfig.SerdeError.class).value(this.getErrorMessage(supported, (CharSequence)charSequence)).build())).orElseGet(() -> this.mapValid(annotation, visitorContext));
    }

    private String getErrorMessage(Set<String> supported, CharSequence member) {
        return "Annotation @" + NameUtils.getSimpleName((String)this.getName()) + " specifies attribute '" + member + "'. Currently supported attributes include: " + supported;
    }

    protected abstract List<AnnotationValue<?>> mapValid(AnnotationValue<Annotation> var1, VisitorContext var2);

    @NonNull
    protected Set<String> getSupportedMemberNames() {
        return Collections.emptySet();
    }
}

