/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.bson;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.inject.annotation.NamedAnnotationTransformer;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.config.annotation.SerdeConfig;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;

public class BsonPropertyTransformer
implements NamedAnnotationTransformer {
    private static final String BSON_DEFAULT_DISCRIMINATOR_PROPERTY_NAME = "_t";

    public String getName() {
        return "org.bson.codecs.pojo.annotations.BsonProperty";
    }

    public List<AnnotationValue<?>> transform(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        AnnotationValueBuilder builder = AnnotationValue.builder(SerdeConfig.class);
        annotation.stringValue().ifPresent(s -> builder.member("property", s));
        if (annotation.booleanValue("useDiscriminator").orElse(false).booleanValue()) {
            builder.member("typeName", "$CLASS_SIMPLE_NAME");
            builder.member("typeProperty", BSON_DEFAULT_DISCRIMINATOR_PROPERTY_NAME);
        }
        return Collections.singletonList(builder.build());
    }
}

