/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.jackson.databind;

import io.micronaut.core.annotation.AccessorsStyle;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.annotation.Serdeable;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.processor.jackson.ValidatingAnnotationMapper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class JsonDeserializeMapper
extends ValidatingAnnotationMapper {
    @Override
    protected List<AnnotationValue<?>> mapValid(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        ArrayList annotations = new ArrayList();
        annotation.annotationClassValue("as").ifPresent(as -> annotations.add(AnnotationValue.builder(SerdeConfig.class).member("deserAs", new AnnotationClassValue[]{as}).build()));
        annotations.add(AnnotationValue.builder(Serdeable.Deserializable.class).build());
        AnnotationClassValue builderClass = annotation.annotationClassValue("builder").orElse(null);
        if (builderClass != null) {
            AnnotationValueBuilder builderDef = AnnotationValue.builder(Introspected.IntrospectionBuilder.class);
            builderDef.member("builderClass", new AnnotationClassValue[]{builderClass});
            visitorContext.getClassElement(builderClass.getName()).ifPresent(t -> {
                AnnotationValue jsonPojoAnn = t.getAnnotation("com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder");
                if (jsonPojoAnn != null) {
                    jsonPojoAnn.stringValue("buildMethodName").ifPresent(n -> builderDef.member("creatorMethod", n));
                    jsonPojoAnn.stringValue("withPrefix").ifPresent(n -> builderDef.member("accessorStyle", AnnotationValue.builder(AccessorsStyle.class).member("writePrefixes", n).build()));
                }
            });
            AnnotationValueBuilder builder = AnnotationValue.builder(Introspected.class).member("builder", builderDef.build()).member("builderClass", new AnnotationClassValue[]{builderClass});
            annotations.add(builder.build());
        }
        return annotations;
    }

    @Override
    protected Set<String> getSupportedMemberNames() {
        return Set.of("as", "builder");
    }

    public String getName() {
        return "com.fasterxml.jackson.databind.annotation.JsonDeserialize";
    }
}

