/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor;

import io.micronaut.context.annotation.Executable;
import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.annotation.SerdeImport;
import io.micronaut.serde.annotation.Serdeable;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import java.lang.annotation.Annotation;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SerdeAnnotationVisitor
implements TypeElementVisitor<SerdeConfig, SerdeConfig> {
    private boolean failOnError = true;
    private ClassElement currentClass;
    private MethodElement anyGetterMethod;
    private MethodElement anySetterMethod;
    private FieldElement anyGetterField;
    private FieldElement anySetterField;
    private MethodElement jsonValueMethod;
    private FieldElement jsonValueField;
    private final Set<String> readMethods = new HashSet<String>(20);
    private final Set<String> writeMethods = new HashSet<String>(20);
    private final Set<String> elementVisitedAsSubtype = new HashSet<String>(10);
    private SerdeConfig.SerCreatorMode creatorMode = SerdeConfig.SerCreatorMode.PROPERTIES;

    public Set<String> getSupportedAnnotationNames() {
        return CollectionUtils.setOf((Object[])new String[]{"com.fasterxml.jackson.annotation.*", "jakarta.json.bind.annotation.*", "io.micronaut.serde.annotation.*", "org.bson.codecs.pojo.annotations.*", "io.micronaut.serde.config.annotation.*", "com.fasterxml.jackson.databind.annotation.*"});
    }

    private Set<String> getUnsupportedJacksonAnnotations() {
        return CollectionUtils.setOf((Object[])new String[]{"com.fasterxml.jackson.annotation.JsonKey", "com.fasterxml.jackson.annotation.JsonAutoDetect", "com.fasterxml.jackson.annotation.JsonMerge", "com.fasterxml.jackson.annotation.JsonIdentityInfo", "com.fasterxml.jackson.annotation.JsonIdentityReference"});
    }

    public void visitField(FieldElement element, VisitorContext context) {
        if (this.checkForErrors((Element)element, context)) {
            return;
        }
        this.checkForFieldErrors(element, context);
    }

    private void checkForFieldErrors(FieldElement element, VisitorContext context) {
        if (this.failOnError) {
            if (element.hasDeclaredAnnotation(SerdeConfig.SerAnyGetter.class)) {
                if (element.hasDeclaredAnnotation(SerdeConfig.SerUnwrapped.class)) {
                    context.fail("A field annotated with AnyGetter cannot be unwrapped", (Element)element);
                } else if (element.hasDeclaredAnnotation(SerdeConfig.SerValue.class)) {
                    context.fail("A field annotated with AnyGetter cannot be a JsonValue", (Element)element);
                } else if (!element.getGenericField().isAssignable(Map.class)) {
                    context.fail("A field annotated with AnyGetter must be a Map", (Element)element);
                } else if (this.anyGetterField != null) {
                    context.fail("Only a single AnyGetter field is supported, another defined: " + this.anyGetterField.getDescription(true), (Element)element);
                } else if (this.anyGetterMethod != null) {
                    context.fail("Cannot define both an AnyGetter field and an AnyGetter method: " + this.anyGetterMethod.getDescription(true), (Element)element);
                } else {
                    this.anyGetterField = element;
                }
            } else if (element.hasDeclaredAnnotation(SerdeConfig.SerAnySetter.class)) {
                if (this.creatorMode == SerdeConfig.SerCreatorMode.DELEGATING) {
                    context.fail("A field annotated with AnySetter cannot use DELEGATING creation", (Element)element);
                } else if (element.hasDeclaredAnnotation(SerdeConfig.SerUnwrapped.class)) {
                    context.fail("A field annotated with AnySetter cannot be unwrapped", (Element)element);
                } else if (!element.getGenericField().isAssignable(Map.class)) {
                    context.fail("A field annotated with AnySetter must be a Map", (Element)element);
                } else if (this.anySetterField != null) {
                    context.fail("Only a single AnySetter field is supported, another defined: " + this.anySetterField.getDescription(true), (Element)element);
                } else if (this.anySetterMethod != null) {
                    context.fail("Cannot define both an AnySetter field and an AnySetter method: " + this.anySetterMethod.getDescription(true), (Element)element);
                } else {
                    this.anySetterField = element;
                }
            } else if (element.hasDeclaredAnnotation(SerdeConfig.SerValue.class)) {
                if (this.jsonValueField != null) {
                    context.fail("A JsonValue field is already defined: " + this.jsonValueField, (Element)element);
                } else if (this.jsonValueMethod != null) {
                    context.fail("A JsonValue method is already defined: " + this.jsonValueMethod, (Element)element);
                } else {
                    this.jsonValueField = element;
                }
            }
        }
    }

    public void visitConstructor(ConstructorElement element, VisitorContext context) {
        if (this.checkForErrors((Element)element, context)) {
            return;
        }
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (this.checkForErrors((Element)element, context) || element.getDeclaringType().getAnnotationMetadata().hasAnnotation(SerdeImport.class)) {
            return;
        }
        AnnotationMetadata declaredMetadata = element.getDeclaredMetadata();
        if (declaredMetadata.hasDeclaredAnnotation("Property") || declaredMetadata.stringValue(SerdeConfig.class, "property").isPresent()) {
            ParameterElement[] parameters = element.getParameters();
            if (element.isStatic()) {
                context.fail("A method annotated with JsonProperty cannot be static", (Element)element);
            } else if (parameters.length == 0) {
                if (element.getReturnType().getName().equals("void")) {
                    context.fail("A method annotated with JsonProperty cannot return void", (Element)element);
                } else if (!this.readMethods.contains(element.getName())) {
                    element.annotate(Executable.class);
                    element.annotate(SerdeConfig.SerGetter.class);
                }
            } else if (parameters.length == 1) {
                if (!this.writeMethods.contains(element.getName())) {
                    element.annotate(Executable.class);
                    element.annotate(SerdeConfig.SerSetter.class);
                }
            } else {
                context.fail("A method annotated with JsonProperty must specify at most 1 argument", (Element)element);
            }
        } else if (declaredMetadata.hasDeclaredAnnotation(SerdeConfig.SerGetter.class)) {
            if (element.isStatic()) {
                context.fail("A method annotated with JsonGetter cannot be static", (Element)element);
            } else if (element.getReturnType().getName().equals("void")) {
                context.fail("A method annotated with JsonGetter cannot return void", (Element)element);
            } else if (element.hasParameters()) {
                context.fail("A method annotated with JsonGetter cannot define arguments", (Element)element);
            }
        } else if (declaredMetadata.hasDeclaredAnnotation(SerdeConfig.SerSetter.class)) {
            if (element.isStatic()) {
                context.fail("A method annotated with JsonSetter cannot be static", (Element)element);
            } else {
                ParameterElement[] parameters = element.getParameters();
                if (parameters.length != 1) {
                    context.fail("A method annotated with JsonSetter must specify exactly 1 argument", (Element)element);
                }
            }
        } else if (declaredMetadata.hasDeclaredAnnotation(SerdeConfig.SerAnyGetter.class)) {
            if (this.anyGetterMethod == null) {
                this.anyGetterMethod = element;
            } else {
                context.fail("Type already defines a method annotated with JsonAnyGetter: " + this.anyGetterMethod.getDescription(true), (Element)element);
            }
            if (declaredMetadata.hasDeclaredAnnotation(SerdeConfig.SerUnwrapped.class)) {
                context.fail("A method annotated with AnyGetter cannot be unwrapped", (Element)element);
            } else if (element.isStatic()) {
                context.fail("A method annotated with AnyGetter cannot be static", (Element)element);
            } else if (!element.getGenericReturnType().isAssignable(Map.class)) {
                context.fail("A method annotated with AnyGetter must return a Map", (Element)element);
            } else if (element.hasParameters()) {
                context.fail("A method annotated with AnyGetter cannot define arguments", (Element)element);
            }
        } else if (declaredMetadata.hasDeclaredAnnotation(SerdeConfig.SerAnySetter.class)) {
            if (this.anySetterMethod == null) {
                this.anySetterMethod = element;
            } else {
                context.fail("Type already defines a method annotated with JsonAnySetter: " + this.anySetterMethod.getDescription(true), (Element)element);
            }
            if (declaredMetadata.hasDeclaredAnnotation(SerdeConfig.SerUnwrapped.class)) {
                context.fail("A method annotated with AnyGetter cannot be unwrapped", (Element)element);
            } else if (element.isStatic()) {
                context.fail("A method annotated with AnySetter cannot be static", (Element)element);
            } else {
                ParameterElement[] parameters = element.getParameters();
                if (parameters.length == 1) {
                    if (!parameters[0].getGenericType().isAssignable(Map.class)) {
                        context.fail("A method annotated with AnySetter must either define a single parameter of type Map or define exactly 2 parameters, the first of which should be of type String", (Element)element);
                    }
                } else if (parameters.length != 2 || !parameters[0].getGenericType().isAssignable(String.class)) {
                    context.fail("A method annotated with AnySetter must either define a single parameter of type Map or define exactly 2 parameters, the first of which should be of type String", (Element)element);
                }
            }
        } else if (declaredMetadata.hasDeclaredAnnotation(SerdeConfig.SerValue.class)) {
            if (this.jsonValueField != null) {
                context.fail("A JsonValue field is already defined: " + this.jsonValueField, (Element)element);
            } else if (this.jsonValueMethod != null) {
                context.fail("A JsonValue method is already defined: " + this.jsonValueMethod, (Element)element);
            } else {
                this.jsonValueMethod = element;
            }
        }
    }

    private boolean checkForErrors(Element element, VisitorContext context) {
        String pattern;
        Class t;
        String defaultValue;
        if (!this.failOnError) {
            return false;
        }
        if (element instanceof MethodElement) {
            if (this.readMethods.contains(element.getName()) && !((MethodElement)element).hasParameters()) {
                return false;
            }
            if (this.writeMethods.contains(element.getName()) && ((MethodElement)element).getParameters().length == 1) {
                return false;
            }
        }
        if (element instanceof MethodElement && element.hasDeclaredAnnotation(SerdeConfig.class) && element.isPrivate()) {
            context.fail("JSON annotations cannot be used on private methods and constructors", element);
            return true;
        }
        for (String annotation : this.getUnsupportedJacksonAnnotations()) {
            if (!element.hasDeclaredAnnotation(annotation)) continue;
            context.fail("Annotation @" + NameUtils.getSimpleName((String)annotation) + " is not supported", element);
            return true;
        }
        String error = element.stringValue(SerdeConfig.SerError.class).orElse(null);
        if (error != null) {
            context.fail(error, element);
            return true;
        }
        ClassElement propertyType = this.resolvePropertyType(element);
        if (propertyType == null) {
            return false;
        }
        boolean isBasicType = SerdeAnnotationVisitor.isBasicType(propertyType);
        if (isBasicType && (defaultValue = (String)element.stringValue(Bindable.class, "defaultValue").orElse(null)) != null && (t = propertyType.isPrimitive() ? (Class)ClassUtils.getPrimitiveType((String)propertyType.getName()).map(ReflectionUtils::getWrapperType).orElse(null) : (Class)ClassUtils.forName((String)propertyType.getName(), (ClassLoader)this.getClass().getClassLoader()).orElse(null)) != null) {
            try {
                if (ConversionService.SHARED.canConvert(String.class, t)) {
                    ConversionService.SHARED.convertRequired((Object)defaultValue, t);
                }
            }
            catch (ConversionErrorException e) {
                context.fail("Invalid defaultValue [" + defaultValue + "] specified: " + e.getConversionError().getCause().getMessage(), element);
                return true;
            }
        }
        if ((pattern = (String)element.stringValue(SerdeConfig.class, "pattern").orElse(null)) != null && this.failOnError) {
            if (this.isNumberType(propertyType)) {
                try {
                    new DecimalFormat(pattern);
                }
                catch (Exception e) {
                    context.fail("Specified pattern [" + pattern + "] is not a valid decimal format. See the javadoc for DecimalFormat: " + e.getMessage(), element);
                    return true;
                }
            }
            if (propertyType.isAssignable(Temporal.class)) {
                try {
                    DateTimeFormatter.ofPattern(pattern);
                }
                catch (Exception e) {
                    context.fail("Specified pattern [" + pattern + "] is not a valid date format. See the javadoc for DateTimeFormatter: " + e.getMessage(), element);
                    return true;
                }
            }
        }
        if (this.handleManagedRef(element, context, propertyType, isBasicType)) {
            return true;
        }
        if (this.handleBackRef(element, context, propertyType, isBasicType)) {
            return true;
        }
        if (this.hasAnnotationOnElement(element, SerdeConfig.SerUnwrapped.class)) {
            if (SerdeAnnotationVisitor.isBasicType(propertyType)) {
                context.fail("Unwrapped cannot be declared on basic types", element);
                return true;
            }
            List<String> thatProperties = this.resolvePropertyNames(context, propertyType, element);
            List<String> thisProperties = this.resolvePropertyNames(context, this.currentClass, null);
            for (String thisProperty : thisProperties) {
                for (String thatProperty : thatProperties) {
                    if (!thisProperty.equals(thatProperty)) continue;
                    context.fail("Unwrapped property contains a property [" + thatProperty + "] that conflicts with an existing property of the outer type: " + this.currentClass.getName() + ". Consider specifying a prefix or suffix to disambiguate this conflict.", element);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean handleBackRef(Element element, VisitorContext context, ClassElement propertyType, boolean isBasicType) {
        if (this.hasAnnotationOnElement(element, SerdeConfig.SerBackRef.class)) {
            if (this.hasAnnotationOnElement(element, SerdeConfig.SerUnwrapped.class)) {
                context.fail("Managed references cannot be unwrapped", element);
                return true;
            }
            if (isBasicType) {
                context.fail("Back references cannot be declared on basic types", element);
                return true;
            }
            if (this.isCollectionType(propertyType)) {
                context.fail("Back references cannot be declared on collection, array or Map types and must be simple beans", element);
                return true;
            }
            String otherSide = element.stringValue(SerdeConfig.SerBackRef.class).orElse(null);
            List<TypedElement> inverseElements = this.resolveInverseElements(context, propertyType, SerdeConfig.SerManagedRef.class, element.getName());
            if (otherSide == null) {
                int i = inverseElements.size();
                if (i > 1) {
                    context.fail("More than one potential inverse property found  " + inverseElements + ", consider specifying a value to the reference to configure the association", element);
                    return true;
                }
                if (i == 0) {
                    context.fail("No inverse property found for reference of type " + propertyType.getName(), element);
                    return true;
                }
                TypedElement otherElement = inverseElements.iterator().next();
                if (!this.isCompatibleInverseSide(otherElement.getGenericType(), this.currentClass)) {
                    context.fail("Back reference declares an incompatible inverse property [" + otherElement + "]. The inverse side should be a map, collection, bean or array of the same type as the property.", element);
                    return true;
                }
                element.annotate(SerdeConfig.SerBackRef.class, builder -> builder.value(otherElement.getName()));
            } else {
                TypedElement otherElement = inverseElements.stream().filter(p -> p.getName().equals(otherSide)).findFirst().orElse(null);
                if (otherElement == null) {
                    context.fail("Back reference declares an inverse property [" + otherSide + "] that doesn't exist in type " + propertyType.getName(), element);
                    return true;
                }
                if (!this.isCompatibleInverseSide(otherElement.getGenericType(), this.currentClass)) {
                    context.fail("Back reference declares an incompatible inverse property [" + otherSide + "]. The inverse side should be a map, collection, bean or array of the same type as the property.", element);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean handleManagedRef(Element element, VisitorContext context, ClassElement propertyType, boolean isBasicType) {
        if (this.hasAnnotationOnElement(element, SerdeConfig.SerManagedRef.class)) {
            if (this.hasAnnotationOnElement(element, SerdeConfig.SerUnwrapped.class)) {
                context.fail("Managed references cannot be unwrapped", element);
                return true;
            }
            if (isBasicType) {
                context.fail("Managed references cannot be declared on basic types", element);
                return true;
            }
            String otherSide = element.stringValue(SerdeConfig.SerManagedRef.class).orElse(null);
            if (otherSide == null) {
                List<TypedElement> inverseElements = this.resolveInverseElements(context, this.resolveRefType(propertyType), SerdeConfig.SerBackRef.class, element.getName());
                int i = inverseElements.size();
                if (i == 0) {
                    context.fail("No inverse property found for reference of type " + propertyType.getName(), element);
                    return true;
                }
                if (i > 1) {
                    context.fail("More than one potential inverse property found " + inverseElements + ", consider specifying a value to the reference to configure the association", element);
                    return true;
                }
                TypedElement otherElement = inverseElements.iterator().next();
                if (!this.isCompatibleInverseSide(otherElement.getGenericType(), this.currentClass)) {
                    context.fail("Managed reference declares an incompatible inverse property [" + otherElement + "]. The inverse side should be a map, collection, bean or array of the same type as the property.", element);
                    return true;
                }
                element.annotate(SerdeConfig.SerManagedRef.class, builder -> builder.value(otherElement.getName()));
            }
        }
        return false;
    }

    private boolean hasAnnotationOnElement(Element element, Class<? extends Annotation> managedRefClass) {
        return element.hasDeclaredAnnotation(managedRefClass) || element instanceof PropertyElement && element.hasAnnotation(managedRefClass);
    }

    private String resolveJsonName(TypedElement thisProperty) {
        return thisProperty.stringValue(SerdeConfig.class, "property").orElseGet(() -> {
            if (thisProperty instanceof MethodElement) {
                return NameUtils.getPropertyNameForGetter((String)thisProperty.getName());
            }
            return thisProperty.getName();
        });
    }

    private ClassElement resolveRefType(ClassElement propertyType) {
        if (propertyType.isArray()) {
            return propertyType.fromArray();
        }
        if (propertyType.isAssignable(Iterable.class)) {
            return propertyType.getFirstTypeArgument().orElse(propertyType);
        }
        if (propertyType.isAssignable(Map.class)) {
            List boundGenericTypes = propertyType.getBoundGenericTypes();
            if (boundGenericTypes.size() == 2) {
                return (ClassElement)boundGenericTypes.get(1);
            }
            return propertyType;
        }
        return propertyType;
    }

    private List<TypedElement> resolveInverseElements(VisitorContext context, ClassElement propertyType, Class<? extends Annotation> refType, String thisSide) {
        Set<Introspected.AccessKind> accessKindSet = this.resolveAccessSet(context, propertyType);
        ArrayList<TypedElement> otherElements = new ArrayList<TypedElement>();
        if (accessKindSet.contains(Introspected.AccessKind.METHOD)) {
            List beanProperties = propertyType.getBeanProperties();
            beanProperties.stream().filter(p -> this.isMappedCandidate(refType, thisSide, (AnnotationMetadata)p) && p.hasAnnotation(refType) && this.isCompatibleInverseSide(p.getGenericType(), this.currentClass)).forEach(otherElements::add);
        }
        if (accessKindSet.contains(Introspected.AccessKind.FIELD)) {
            List fields = propertyType.getEnclosedElements(ElementQuery.ALL_FIELDS.onlyInstance().annotated(ann -> this.isMappedCandidate(refType, thisSide, (AnnotationMetadata)ann) && ann.hasDeclaredAnnotation(refType)).modifiers(m -> m.contains(ElementModifier.PUBLIC)).typed(t -> this.isCompatibleInverseSide(t.getGenericType(), this.currentClass)));
            otherElements.addAll(fields);
        }
        return otherElements;
    }

    private List<String> resolvePropertyNames(VisitorContext context, ClassElement propertyType, @Nullable Element annotationSource) {
        Stream<Object> typeElements;
        Object[] includedSource = annotationSource == null ? null : annotationSource.stringValues(SerdeConfig.SerIncluded.class);
        Object[] includedType = propertyType.stringValues(SerdeConfig.SerIncluded.class);
        Object includeSet = ArrayUtils.isEmpty((Object[])includedSource) ? (ArrayUtils.isEmpty((Object[])includedType) ? null : CollectionUtils.setOf((Object[])includedType)) : CollectionUtils.setOf((Object[])includedSource);
        Object[] ignoredSource = annotationSource == null ? null : annotationSource.stringValues(SerdeConfig.SerIgnored.class);
        Object[] ignoredType = propertyType.stringValues(SerdeConfig.SerIgnored.class);
        Object ignoreSet = ArrayUtils.isEmpty((Object[])ignoredSource) ? (ArrayUtils.isEmpty((Object[])ignoredType) ? null : CollectionUtils.setOf((Object[])ignoredType)) : CollectionUtils.setOf((Object[])ignoredSource);
        Set<Introspected.AccessKind> accessKindSet = this.resolveAccessSet(context, propertyType);
        if (accessKindSet.contains(Introspected.AccessKind.METHOD)) {
            typeElements = propertyType.getBeanProperties().stream().filter(p -> !p.hasDeclaredAnnotation(SerdeConfig.SerIgnored.class));
        } else if (accessKindSet.contains(Introspected.AccessKind.FIELD)) {
            List fields = propertyType.getEnclosedElements(ElementQuery.ALL_FIELDS.onlyInstance().annotated(ann -> !ann.hasDeclaredAnnotation(SerdeConfig.SerIgnored.class)).modifiers(m -> m.contains(ElementModifier.PUBLIC)));
            typeElements = fields.stream();
        } else {
            typeElements = Stream.empty();
        }
        return typeElements.map(this::resolveJsonName).filter(arg_0 -> SerdeAnnotationVisitor.lambda$resolvePropertyNames$11((Set)ignoreSet, (Set)includeSet, arg_0)).collect(Collectors.toList());
    }

    private boolean isMappedCandidate(Class<? extends Annotation> refType, String thisSide, AnnotationMetadata p) {
        String mappedName = p.stringValue(refType).orElse(null);
        return mappedName == null || mappedName.equals(thisSide);
    }

    private Set<Introspected.AccessKind> resolveAccessSet(VisitorContext context, ClassElement propertyType) {
        Object[] accessKinds = context.getClassElement(propertyType.getName()).map(t -> (Introspected.AccessKind[])t.enumValues(Introspected.class, "accessKind", Introspected.AccessKind.class)).orElse(null);
        return ArrayUtils.isNotEmpty((Object[])accessKinds) ? CollectionUtils.setOf((Object[])accessKinds) : Collections.singleton(Introspected.AccessKind.METHOD);
    }

    private boolean isCompatibleInverseSide(ClassElement genericType, ClassElement propertyType) {
        if (genericType.isAssignable(propertyType)) {
            return true;
        }
        if (genericType.isArray() && genericType.fromArray().isAssignable(propertyType)) {
            return true;
        }
        if (genericType.isAssignable(Iterable.class) && genericType.getFirstTypeArgument().map(t -> t.isAssignable(propertyType)).orElse(false).booleanValue()) {
            return true;
        }
        if (genericType.isAssignable(Map.class)) {
            List types = genericType.getBoundGenericTypes();
            return types.size() == 2 && ((ClassElement)types.get(1)).isAssignable(propertyType);
        }
        return false;
    }

    private boolean isCollectionType(ClassElement element) {
        return element.isArray() || element.isAssignable(Iterable.class) || element.isAssignable(Map.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isNumberType(ClassElement type) {
        if (type == null) {
            return false;
        }
        if (type.isAssignable(Number.class)) return true;
        if (!type.isPrimitive()) return false;
        if (ClassUtils.getPrimitiveType((String)type.getName()).map(ReflectionUtils::getWrapperType).map(Number.class::isAssignableFrom).orElse(false) == false) return false;
        return true;
    }

    @Nullable
    private ClassElement resolvePropertyType(Element element) {
        ClassElement type = null;
        if (element instanceof FieldElement) {
            type = ((FieldElement)element).getGenericField().getType();
        } else if (element instanceof MethodElement) {
            MethodElement methodElement = (MethodElement)element;
            type = !methodElement.hasParameters() ? methodElement.getGenericReturnType() : methodElement.getParameters()[0].getGenericType();
        } else if (element instanceof PropertyElement) {
            return ((PropertyElement)element).getGenericType();
        }
        return type;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        this.resetForNewClass(element);
        if (this.checkForErrors((Element)element, context)) {
            return;
        }
        this.visitClassInternal(element, context, false);
    }

    private void visitClassSubtypes(ClassElement supertype, VisitorContext context) {
        List subtypes = supertype.getDeclaredAnnotationValuesByType(SerdeConfig.SerSubtyped.SerSubtype.class);
        for (AnnotationValue subtypeAnn : subtypes) {
            subtypeAnn.stringValue().flatMap(arg_0 -> ((VisitorContext)context).getClassElement(arg_0)).ifPresent(subtype -> {
                if (!subtype.hasStereotype(SerdeConfig.class)) {
                    subtype.annotate(Serdeable.class);
                    this.visitSubtype(supertype, (ClassElement)subtype, context);
                }
            });
        }
    }

    private void visitSubtype(ClassElement supertype, ClassElement subtype, VisitorContext context) {
        if (this.elementVisitedAsSubtype.contains(subtype.getName())) {
            return;
        }
        this.elementVisitedAsSubtype.add(subtype.getName());
        if (this.failOnError && this.creatorMode == SerdeConfig.SerCreatorMode.DELEGATING) {
            context.fail("Inheritance cannot be combined with DELEGATING creation", (Element)subtype);
            return;
        }
        if (!subtype.hasAnnotation(SerdeConfig.SerIgnored.class)) {
            AnnotationValue serIgnored = supertype.getAnnotation(SerdeConfig.SerIgnored.class);
            if (serIgnored != null) {
                subtype.annotate(serIgnored);
            }
            this.visitProperties(subtype, context);
        }
        SerdeConfig.SerSubtyped.DiscriminatorValueKind discriminatorValueKind = this.getDiscriminatorValueKind(supertype);
        SerdeConfig.SerSubtyped.DiscriminatorType discriminatorType = this.getDiscriminatorType(supertype);
        String typeProperty = this.resolveTypeProperty(supertype).orElseThrow();
        ArrayList<String> allNames = new ArrayList<String>();
        switch (discriminatorValueKind) {
            case NAME: {
                subtype.stringValue(SerdeConfig.class, "typeName").ifPresent(allNames::add);
                for (AnnotationValue parentSubtype : supertype.getDeclaredAnnotationValuesByType(SerdeConfig.SerSubtyped.SerSubtype.class)) {
                    String parentSubtypeName = parentSubtype.stringValue().orElse(null);
                    if (!subtype.getName().equals(parentSubtypeName)) continue;
                    parentSubtype.stringValue("name").ifPresent(allNames::add);
                    Collections.addAll(allNames, parentSubtype.stringValues("names"));
                }
                if (!allNames.isEmpty()) break;
                allNames.add(subtype.getSimpleName());
                break;
            }
            case CLASS_SIMPLE_NAME: {
                allNames.add(subtype.getSimpleName());
                break;
            }
            case MINIMAL_CLASS: {
                String superPackage = supertype.getPackage().getName();
                String name = subtype.getName();
                String typeName = name.startsWith(superPackage) ? name.substring(superPackage.length()) : name;
                allNames.add(typeName);
                break;
            }
            default: {
                allNames.add(subtype.getName());
            }
        }
        subtype.annotate(SerdeConfig.class, builder -> {
            builder.member("typeName", (String)allNames.get(0));
            builder.member("typeNames", allNames.toArray(new String[0]));
            if (discriminatorType == SerdeConfig.SerSubtyped.DiscriminatorType.WRAPPER_OBJECT) {
                builder.member("wrapperProperty", (String)allNames.get(0));
            } else {
                builder.member("typeProperty", typeProperty);
            }
            if (supertype.booleanValue(SerdeConfig.SerSubtyped.class, "discriminatorVisible").orElse(false).booleanValue()) {
                builder.member("typePropertyVisible", true);
            }
        });
    }

    private void visitClassInternal(ClassElement element, VisitorContext context, boolean isImport) {
        this.visitClassSubtypes(element, context);
        if (element.hasDeclaredAnnotation(SerdeImport.Repeated.class) && !isImport) {
            List values = element.getDeclaredAnnotationValuesByType(SerdeImport.class);
            ArrayList classValues = new ArrayList();
            for (AnnotationValue value : values) {
                value.annotationClassValue("value").flatMap(acv -> context.getClassElement(acv.getName())).ifPresent(c -> {
                    if (!c.isPublic()) {
                        context.fail("Cannot mixin non-public type: " + c.getName(), (Element)element);
                    } else {
                        this.handleClassImport(context, (AnnotationValue<SerdeImport>)value, (ClassElement)c, classValues);
                    }
                });
                value.stringValue("packageName").ifPresent(packageName -> {
                    ClassElement[] classElements;
                    for (ClassElement c : classElements = context.getClassElements(packageName, new String[]{"*"})) {
                        if (!c.isPublic()) continue;
                        this.handleClassImport(context, (AnnotationValue<SerdeImport>)value, c, classValues);
                    }
                });
            }
            element.annotate(Introspected.class, builder -> builder.member("classes", classValues.toArray(new AnnotationClassValue[0])));
        } else if (this.isJsonAnnotated(element) || isImport) {
            ClassElement thatType;
            ClassElement thatType2;
            String serializeAs;
            if (!(element.hasStereotype(Serdeable.Serializable.class) || element.hasStereotype(Serdeable.Deserializable.class) || isImport)) {
                element.annotate(Serdeable.class);
                element.annotate(Introspected.class, i -> {
                    i.member("accessKind", new Enum[]{Introspected.AccessKind.METHOD, Introspected.AccessKind.FIELD});
                    i.member("visibility", "PUBLIC");
                });
            }
            if ((serializeAs = (String)element.getDeclaredMetadata().stringValue(SerdeConfig.class, "serAs").orElse(null)) != null && (thatType2 = (ClassElement)context.getClassElement(serializeAs).orElse(null)) != null && !thatType2.isAssignable(element)) {
                context.fail("Type to serialize as [" + serializeAs + "], must be a subtype of the annotated type: " + element.getName(), (Element)element);
                return;
            }
            String deserializeAs = element.getDeclaredMetadata().stringValue(SerdeConfig.class, "deserAs").orElse(null);
            if (deserializeAs != null && (thatType = (ClassElement)context.getClassElement(deserializeAs).orElse(null)) != null && !thatType.isAssignable(element)) {
                context.fail("Type to deserialize as [" + deserializeAs + "], must be a subtype of the annotated type: " + element.getName(), (Element)element);
                return;
            }
            MethodElement primaryConstructor = element.getPrimaryConstructor().orElse(null);
            if (primaryConstructor != null) {
                this.creatorMode = primaryConstructor.enumValue(Creator.class, "mode", SerdeConfig.SerCreatorMode.class).orElse(null);
                if (this.creatorMode == SerdeConfig.SerCreatorMode.DELEGATING && this.failOnError && primaryConstructor.getParameters().length != 1) {
                    context.fail("DELEGATING creator mode requires exactly one Creator parameter, but more were defined.", (Element)element);
                }
            }
            this.visitProperties(element, context);
            this.findTypeInfo(element, false).ifPresent(superType -> this.visitSubtype((ClassElement)superType, element, context));
            if (this.failOnError && element.hasDeclaredAnnotation(SerdeConfig.SerSubtyped.class) && this.creatorMode == SerdeConfig.SerCreatorMode.DELEGATING) {
                context.fail("Inheritance cannot be combined with DELEGATING creation", (Element)element);
            }
        }
    }

    private void visitProperties(ClassElement classElement, VisitorContext context) {
        List beanProperties = classElement.getBeanProperties();
        List<String> order = Arrays.asList(classElement.stringValues("PropertyOrder"));
        Collections.reverse(order);
        Set access = CollectionUtils.setOf((Object[])((Introspected.AccessKind[])classElement.enumValues(Introspected.class, "accessKind", Introspected.AccessKind.class)));
        boolean supportFields = access.contains(Introspected.AccessKind.FIELD);
        String[] ignoresProperties = classElement.stringValues(SerdeConfig.SerIgnored.class);
        String[] includeProperties = classElement.stringValues(SerdeConfig.SerIncluded.class);
        boolean ignoreOnlyDeserialization = classElement.booleanValue(SerdeConfig.SerIgnored.class, "allowSerialize").orElse(false);
        boolean ignoreOnlySerialization = classElement.booleanValue(SerdeConfig.SerIgnored.class, "allowDeserialize").orElse(false);
        PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy((TypedElement)classElement, null);
        this.processProperties(context, beanProperties, order, ignoresProperties, includeProperties, ignoreOnlyDeserialization, ignoreOnlySerialization, propertyNamingStrategy);
        if (supportFields) {
            List fields = classElement.getEnclosedElements(ElementQuery.ALL_FIELDS.onlyInstance().onlyAccessible());
            this.processProperties(context, fields, order, ignoresProperties, includeProperties, ignoreOnlyDeserialization, ignoreOnlySerialization, propertyNamingStrategy);
        }
    }

    private void handleClassImport(VisitorContext context, AnnotationValue<SerdeImport> value, ClassElement c, List<AnnotationClassValue<?>> classValues) {
        classValues.add(new AnnotationClassValue(c.getName()));
        ClassElement mixinType = value.stringValue("mixin").flatMap(arg_0 -> ((VisitorContext)context).getClassElement(arg_0)).orElse(null);
        if (mixinType != null) {
            this.visitMixin(mixinType, c);
        } else {
            this.visitClassInternal(c, context, true);
        }
        c.annotate(value);
        AnnotationValue jsonPojoAnn = c.getAnnotation("com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder");
        if (jsonPojoAnn != null) {
            String buildMethod = jsonPojoAnn.stringValue("buildMethodName").orElse("build");
            c.getEnclosedElement(ElementQuery.ALL_METHODS.named(n -> n.equals(buildMethod))).ifPresent(m -> m.annotate(Executable.class));
        }
    }

    private void visitMixin(ClassElement mixinType, ClassElement type) {
        mixinType.getAnnotationNames().stream().filter(n -> n.startsWith("io.micronaut.serde")).forEach(n -> {
            AnnotationValue ann = mixinType.getAnnotation(n);
            if (ann != null) {
                type.annotate(ann);
            }
        });
        mixinType.findAnnotation(SerdeConfig.class).ifPresent(arg_0 -> ((ClassElement)type).annotate(arg_0));
        Map<String, FieldElement> serdeFields = mixinType.getEnclosedElements(ElementQuery.ALL_FIELDS.onlyInstance().onlyDeclared().annotated(ann -> ann.hasAnnotation(SerdeConfig.class))).stream().collect(Collectors.toMap(Element::getName, e -> e));
        MethodElement mixinCtor = mixinType.getPrimaryConstructor().orElse(null);
        MethodElement targetCtor = type.getPrimaryConstructor().orElse(null);
        if (mixinCtor != null && targetCtor != null && this.argumentsMatch(mixinCtor, targetCtor)) {
            this.replicateAnnotations((Element)mixinCtor, (Element)targetCtor);
        }
        ArrayList serdeMethods = mixinType.isRecord() ? Collections.emptyList() : new ArrayList(mixinType.getEnclosedElements(ElementQuery.ALL_METHODS.onlyInstance().onlyDeclared().annotated(ann -> ann.getAnnotationNames().stream().anyMatch(n -> n.startsWith("io.micronaut.serde.config.annotation")))));
        List beanProperties = type.getBeanProperties();
        for (PropertyElement beanProperty : beanProperties) {
            FieldElement f = serdeFields.get(beanProperty.getName());
            if (f != null && f.getType().equals(beanProperty.getType())) {
                this.replicateAnnotations((Element)f, (Element)beanProperty);
                continue;
            }
            if (!CollectionUtils.isNotEmpty(serdeMethods)) continue;
            MethodElement readMethod = beanProperty.getReadMethod().orElse(null);
            MethodElement writeMethod = beanProperty.getWriteMethod().orElse(null);
            Iterator i = serdeMethods.iterator();
            while (i.hasNext()) {
                MethodElement serdeMethod = (MethodElement)i.next();
                if (readMethod != null && serdeMethod.getName().equals(readMethod.getName()) && this.argumentsMatch(serdeMethod, readMethod)) {
                    i.remove();
                    this.replicateAnnotations((Element)serdeMethod, (Element)beanProperty);
                    this.replicateAnnotations((Element)serdeMethod, (Element)readMethod);
                }
                if (writeMethod == null || !serdeMethod.getName().equals(writeMethod.getName()) || !this.argumentsMatch(serdeMethod, writeMethod)) continue;
                i.remove();
                this.replicateAnnotations((Element)serdeMethod, (Element)beanProperty);
                this.replicateAnnotations((Element)serdeMethod, (Element)writeMethod);
            }
        }
        if (!serdeMethods.isEmpty()) {
            for (MethodElement serdeMethod : serdeMethods) {
                type.getEnclosedElement(ElementQuery.ALL_METHODS.onlyInstance().onlyAccessible().named(n -> n.equals(serdeMethod.getName())).filter(left -> left.getReturnType().equals(serdeMethod.getReturnType()) && this.argumentsMatch((MethodElement)left, serdeMethod))).ifPresent(m -> {
                    m.annotate(Executable.class);
                    this.replicateAnnotations((Element)serdeMethod, (Element)m);
                });
            }
        }
    }

    private boolean argumentsMatch(MethodElement left, MethodElement right) {
        ParameterElement[] rp;
        ParameterElement[] lp = left.getParameters();
        if (lp.length == (rp = right.getParameters()).length) {
            if (lp.length == 0) {
                return true;
            }
            for (int i = 0; i < lp.length; ++i) {
                ParameterElement p1 = lp[i];
                ParameterElement p2 = rp[i];
                if (p1.getType().equals(p2.getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void replicateAnnotations(Element source, Element target) {
        Set annotationNames = source.getAnnotationNames();
        for (String annotationName : annotationNames) {
            AnnotationValue config = source.getAnnotation(annotationName);
            if (config == null) continue;
            target.annotate(config);
        }
    }

    @Nullable
    private PropertyNamingStrategy getPropertyNamingStrategy(@NonNull TypedElement element, @Nullable PropertyNamingStrategy defaultValue) {
        String namingStrategy = element.stringValue(SerdeConfig.class, "naming").filter(val -> !val.equals(PropertyNamingStrategy.IDENTITY.getClass().getName())).orElse(null);
        if (namingStrategy != null) {
            PropertyNamingStrategy propertyNamingStrategy = PropertyNamingStrategy.forName((String)namingStrategy).orElse(null);
            if (propertyNamingStrategy == null) {
                Object o = InstantiationUtils.tryInstantiate((String)namingStrategy, (ClassLoader)this.getClass().getClassLoader()).orElse(null);
                if (o instanceof PropertyNamingStrategy) {
                    return o;
                }
                element.annotate(SerdeConfig.class, builder -> builder.member("runtimeNaming", namingStrategy));
            }
            return propertyNamingStrategy;
        }
        return defaultValue;
    }

    private void processProperties(VisitorContext context, List<? extends TypedElement> beanProperties, List<String> order, String[] ignoresProperties, String[] includeProperties, boolean ignoreOnlyDeserialization, boolean ignoreOnlySerialization, @Nullable PropertyNamingStrategy namingStrategy) {
        Set ignoredSet = CollectionUtils.setOf((Object[])ignoresProperties);
        Set includeSet = CollectionUtils.setOf((Object[])includeProperties);
        for (TypedElement typedElement : beanProperties) {
            int i;
            if (this.checkForErrors((Element)typedElement, context)) continue;
            PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(typedElement, namingStrategy);
            if (typedElement instanceof PropertyElement) {
                PropertyElement pm = (PropertyElement)typedElement;
                pm.getReadMethod().ifPresent(rm -> this.readMethods.add(rm.getName()));
                pm.getWriteMethod().ifPresent(rm -> this.writeMethods.add(rm.getName()));
            }
            if (!typedElement.isPrimitive() && !typedElement.isArray()) {
                ClassElement t = typedElement.getGenericType();
                this.handleJsonIgnoreType(context, typedElement, t);
            }
            String propertyName = typedElement.getName();
            if (propertyNamingStrategy != null) {
                typedElement.annotate(SerdeConfig.class, builder -> builder.member("property", propertyNamingStrategy.translate((AnnotatedElement)beanProperty)));
            }
            if (CollectionUtils.isNotEmpty(order) && (i = order.indexOf(propertyName)) > -1) {
                typedElement.annotate(Order.class, builder -> builder.value(-(i + 1)));
            }
            if (ignoredSet.contains(propertyName)) {
                this.ignoreProperty(ignoreOnlyDeserialization, ignoreOnlySerialization, typedElement);
                continue;
            }
            if (includeSet.isEmpty() || includeSet.contains(propertyName)) continue;
            this.ignoreProperty(false, false, typedElement);
        }
    }

    private void ignoreProperty(boolean ignoreOnlyDeserialization, boolean ignoreOnlySerialization, TypedElement beanProperty) {
        if (beanProperty instanceof PropertyElement) {
            PropertyElement propertyElement = (PropertyElement)beanProperty;
            if (ignoreOnlySerialization) {
                propertyElement.getReadMethod().ifPresent(e -> e.annotate(SerdeConfig.class, builder -> builder.member("ignoredSerialization", true)));
            } else if (ignoreOnlyDeserialization) {
                propertyElement.getWriteMethod().ifPresent(e -> e.annotate(SerdeConfig.class, builder -> builder.member("ignoredDeserialization", true)));
            } else {
                propertyElement.annotate(SerdeConfig.class, builder -> builder.member("ignored", true));
            }
        } else if (ignoreOnlySerialization) {
            beanProperty.annotate(SerdeConfig.class, builder -> builder.member("ignoredSerialization", true));
        } else if (ignoreOnlyDeserialization) {
            beanProperty.annotate(SerdeConfig.class, builder -> builder.member("ignoredDeserialization", true));
        } else {
            beanProperty.annotate(SerdeConfig.class, builder -> builder.member("ignored", true));
        }
    }

    private void handleJsonIgnoreType(VisitorContext context, TypedElement beanProperty, ClassElement t) {
        boolean ignoredType;
        String typeName = t.getName();
        if (!ClassUtils.isJavaBasicType((String)typeName) && (ignoredType = context.getClassElement(typeName).map(c -> c.hasAnnotation(SerdeConfig.SerIgnored.SerType.class)).orElse(false).booleanValue())) {
            beanProperty.annotate(SerdeConfig.class, builder -> builder.member("ignored", true));
        }
    }

    private void resetForNewClass(ClassElement element) {
        this.currentClass = element;
        this.failOnError = element.booleanValue(SerdeConfig.class, "validate").orElse(true);
        this.creatorMode = SerdeConfig.SerCreatorMode.PROPERTIES;
        this.anyGetterMethod = null;
        this.anySetterMethod = null;
        this.anyGetterField = null;
        this.anySetterField = null;
        this.jsonValueField = null;
        this.jsonValueMethod = null;
        this.readMethods.clear();
        this.writeMethods.clear();
    }

    private SerdeConfig.SerSubtyped.DiscriminatorValueKind getDiscriminatorValueKind(ClassElement typeInfo) {
        return typeInfo.enumValue(SerdeConfig.SerSubtyped.class, "dv", SerdeConfig.SerSubtyped.DiscriminatorValueKind.class).orElse(SerdeConfig.SerSubtyped.DiscriminatorValueKind.CLASS_NAME);
    }

    private Optional<ClassElement> findTypeInfo(ClassElement element, boolean includeElement) {
        if (element.hasDeclaredAnnotation(SerdeConfig.SerSubtyped.class) && includeElement) {
            return Optional.of(element);
        }
        ClassElement superElement = element.getSuperType().orElse(null);
        if (superElement == null) {
            ClassElement itfe = this.findInDeclaredInterfaces(element);
            if (itfe != null) {
                return Optional.of(itfe);
            }
            return Optional.empty();
        }
        if (superElement.hasDeclaredAnnotation(SerdeConfig.SerSubtyped.class)) {
            return Optional.of(superElement);
        }
        ClassElement itfe = this.findInDeclaredInterfaces(element);
        if (itfe == null) {
            itfe = this.findInDeclaredInterfaces(superElement);
        }
        if (itfe != null) {
            return Optional.of(itfe);
        }
        return this.findTypeInfo(superElement, true);
    }

    private ClassElement findInDeclaredInterfaces(@NonNull ClassElement superElement) {
        Collection interfaces = superElement.getInterfaces();
        if (CollectionUtils.isNotEmpty((Collection)interfaces)) {
            for (ClassElement anInterface : interfaces) {
                if (anInterface.hasDeclaredAnnotation(SerdeConfig.SerSubtyped.class)) {
                    return anInterface;
                }
                ClassElement e = this.findInDeclaredInterfaces(anInterface);
                if (e == null) continue;
                return e;
            }
        }
        return null;
    }

    private Optional<String> resolveTypeProperty(@NonNull ClassElement superType) {
        ClassElement typeInfo = this.findTypeInfo(superType, true).orElse(null);
        if (typeInfo != null) {
            return typeInfo.stringValue(SerdeConfig.SerSubtyped.class, "dp");
        }
        return Optional.empty();
    }

    private SerdeConfig.SerSubtyped.DiscriminatorType getDiscriminatorType(ClassElement element) {
        return element.enumValue(SerdeConfig.SerSubtyped.class, "dt", SerdeConfig.SerSubtyped.DiscriminatorType.class).orElse(SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY);
    }

    public int getOrder() {
        return 0;
    }

    private boolean isJsonAnnotated(ClassElement element) {
        return Stream.of("com.fasterxml.jackson.annotation.JsonClassDescription", "com.fasterxml.jackson.databind.annotation.JsonNaming", "com.fasterxml.jackson.databind.annotation.JsonSerialize", "com.fasterxml.jackson.databind.annotation.JsonDeserialize", "com.fasterxml.jackson.annotation.JsonTypeInfo", "com.fasterxml.jackson.annotation.JsonRootName", "com.fasterxml.jackson.annotation.JsonTypeName", "com.fasterxml.jackson.annotation.JsonTypeId", "com.fasterxml.jackson.annotation.JsonAutoDetect", "com.fasterxml.jackson.annotation.JsonIgnoreProperties", "com.fasterxml.jackson.annotation.JsonIncludeProperties").anyMatch(arg_0 -> ((ClassElement)element).hasDeclaredAnnotation(arg_0)) || element.hasStereotype(Serdeable.Serializable.class) || element.hasStereotype(Serdeable.Deserializable.class);
    }

    private static boolean isBasicType(ClassElement propertyType) {
        if (propertyType == null) {
            return false;
        }
        String name = propertyType.getName();
        return ClassUtils.isJavaBasicType((String)name) || propertyType.isPrimitive() && !propertyType.isArray();
    }

    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    private static /* synthetic */ boolean lambda$resolvePropertyNames$11(Set ignoreSet, Set includeSet, String s) {
        return !(ignoreSet != null && ignoreSet.contains(s) || includeSet != null && !includeSet.contains(s));
    }
}

