/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.annotation.SerdeImport;
import io.micronaut.serde.annotation.Serdeable;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.config.annotation.SerdeConfig;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@Singleton
public class DefaultSerdeIntrospections
implements SerdeIntrospections {
    private final Set<String> serdePackages;

    @Inject
    public DefaultSerdeIntrospections(SerdeConfiguration configuration) {
        List introspectionPackages = configuration.getIncludedIntrospectionPackages();
        this.serdePackages = new HashSet<String>(introspectionPackages);
    }

    public DefaultSerdeIntrospections() {
        this.serdePackages = Collections.singleton("io.micronaut");
    }

    public <T> BeanIntrospection<T> getSerializableIntrospection(Argument<T> type) {
        Collection candidates;
        BeanIntrospection i;
        BeanIntrospector beanIntrospector = this.getBeanIntrospector();
        Optional introspection = beanIntrospector.findIntrospection(type.getType());
        BeanIntrospection result = null;
        if (introspection.isPresent() && this.isEnabledForSerialization((AnnotationMetadataProvider)(i = (BeanIntrospection)introspection.get()), type)) {
            result = i;
        }
        if (result == null && CollectionUtils.isNotEmpty((Collection)(candidates = beanIntrospector.findIntrospections(reference -> reference.isPresent() && reference.getBeanType().isAssignableFrom(type.getType()) && this.isEnabledForSerialization((AnnotationMetadataProvider)reference, type))))) {
            result = candidates.size() == 1 ? (BeanIntrospection)candidates.iterator().next() : (BeanIntrospection)OrderUtil.sort(candidates.stream()).findFirst().orElse(null);
        }
        if (result != null) {
            AnnotationMetadata declaredMetadata = result.getDeclaredMetadata();
            AnnotationValue serdeConfig = declaredMetadata.getDeclaredAnnotation(SerdeConfig.class);
            Class beanType = type.getType();
            Class<?> serializeType = this.resolveDeserAsType(beanType, (AnnotationValue<SerdeConfig>)serdeConfig, "serAs");
            if (serializeType != null && !serializeType.equals(beanType)) {
                Argument resolved = Argument.of(serializeType, (String)type.getName(), (AnnotationMetadata)type.getAnnotationMetadata(), (Argument[])type.getTypeParameters());
                return this.getSerializableIntrospection(resolved);
            }
            return result;
        }
        throw new IntrospectionException("No serializable introspection present for type " + type + ". Consider adding Serdeable. Serializable annotate to type " + type + ". Alternatively if you are not in control of the project's source code, you can use @SerdeImport(" + type.getSimpleName() + ".class) to enable serialization of this type.");
    }

    public <T> BeanIntrospection<T> getDeserializableIntrospection(Argument<T> type) {
        Class rawType = type.getType();
        BeanIntrospector beanIntrospector = this.getBeanIntrospector();
        BeanIntrospection introspection = beanIntrospector.findIntrospection(rawType).orElseGet(() -> {
            Class as;
            Serdeable.Deserializable ann = rawType.getAnnotation(Serdeable.Deserializable.class);
            if (ann != null && (as = ann.as()) != Void.TYPE) {
                return beanIntrospector.getIntrospection(as);
            }
            return beanIntrospector.getIntrospection(rawType);
        });
        if (this.isEnabledForDeserialization((AnnotationMetadataProvider)introspection, type)) {
            AnnotationMetadata declaredMetadata = introspection.getDeclaredMetadata();
            AnnotationValue serdeConfig = declaredMetadata.getDeclaredAnnotation(SerdeConfig.class);
            Class<?> deserializeType = this.resolveDeserAsType(introspection.getBeanType(), (AnnotationValue<SerdeConfig>)serdeConfig, "deserAs");
            if (deserializeType != null) {
                Argument resolved = Argument.of(deserializeType, (String)type.getName(), (AnnotationMetadata)type.getAnnotationMetadata(), (Argument[])type.getTypeParameters());
                return this.getDeserializableIntrospection(resolved);
            }
            return introspection;
        }
        throw new IntrospectionException("No deserializable introspection present for type: " + type + ". Consider adding Serdeable.Deserializable annotate to type " + type + ". Alternatively if you are not in control of the project's source code, you can use @SerdeImport(" + type.getSimpleName() + ".class) to enable deserialization of this type.");
    }

    private <T> Class<?> resolveDeserAsType(Class<?> beanType, AnnotationValue<SerdeConfig> serdeConfig, String configMember) {
        Class deserializeType = null;
        if (serdeConfig != null && (deserializeType = (Class)serdeConfig.classValue(configMember).orElse(null)) == null) {
            deserializeType = serdeConfig.stringValue(configMember).flatMap(n -> ClassUtils.forName((String)n, (ClassLoader)beanType.getClassLoader())).orElse(null);
        }
        return deserializeType;
    }

    private boolean isEnabledForDeserialization(AnnotationMetadataProvider reference, Argument<?> type) {
        AnnotationMetadata annotationMetadata = reference.getAnnotationMetadata();
        return this.isWithinSerdePackage(type) || annotationMetadata.hasStereotype(Serdeable.Deserializable.class) && annotationMetadata.booleanValue(Serdeable.Deserializable.class, "enabled").orElse(true) != false || annotationMetadata.hasAnnotation(SerdeImport.class) && this.isMixinEnabledForDeserialization(annotationMetadata.getAnnotationValuesByType(SerdeImport.class), type);
    }

    private boolean isEnabledForSerialization(AnnotationMetadataProvider reference, Argument<?> type) {
        AnnotationMetadata annotationMetadata = reference.getAnnotationMetadata();
        return this.isWithinSerdePackage(type) || annotationMetadata.hasStereotype(Serdeable.Serializable.class) && annotationMetadata.booleanValue(Serdeable.Serializable.class, "enabled").orElse(true) != false || annotationMetadata.hasAnnotation(SerdeImport.class) && this.isMixinEnabledForSerialization(annotationMetadata.getAnnotationValuesByType(SerdeImport.class), type);
    }

    private boolean isWithinSerdePackage(Argument<?> type) {
        return this.serdePackages.stream().anyMatch(p -> type.getTypeName().startsWith(p + "."));
    }

    private <T extends Annotation> boolean isMixinEnabledForDeserialization(List<AnnotationValue<T>> mixinsValues, Argument<?> type) {
        return this.isEnabledForMixin(mixinsValues, type, "deserializable");
    }

    private <T extends Annotation> boolean isMixinEnabledForSerialization(List<AnnotationValue<T>> mixinsValues, Argument<?> type) {
        return this.isEnabledForMixin(mixinsValues, type, "serializable");
    }

    private <T extends Annotation> Boolean isEnabledForMixin(List<AnnotationValue<T>> mixinsValues, Argument<?> type, String member) {
        return mixinsValues.stream().filter(av -> av.classValue().orElse(Object.class).equals((Object)type.getType())).findFirst().flatMap(av -> av.booleanValue(member)).orElse(true);
    }
}

