/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.serdes.FormattedTemporalSerde;
import io.micronaut.serde.support.serdes.TemporalSerde;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DefaultFormattedTemporalSerde<T extends TemporalAccessor>
implements TemporalSerde<T> {
    private final FormattedTemporalSerde<T> defaultFormat;

    protected DefaultFormattedTemporalSerde(@NonNull SerdeConfiguration configuration) {
        String pattern = configuration.getDateFormat().orElse(null);
        if (pattern != null) {
            Locale locale = configuration.getLocale().orElse(null);
            DateTimeFormatter formatter = locale != null ? DateTimeFormatter.ofPattern(pattern, locale) : DateTimeFormatter.ofPattern(pattern);
            TimeZone tz = configuration.getTimeZone().orElse(null);
            if (tz != null) {
                formatter = formatter.withZone(tz.toZoneId());
            }
            this.defaultFormat = new FormattedTemporalSerde(formatter, this.query());
        } else {
            this.defaultFormat = configuration.isWriteDatesAsTimestamps() ? null : new FormattedTemporalSerde(this.getDefaultFormatter(), this.query());
        }
    }

    @NonNull
    protected abstract DateTimeFormatter getDefaultFormatter();

    public final void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        if (this.defaultFormat != null) {
            this.defaultFormat.serialize(encoder, context, type, (T)value);
        } else {
            this.serializeWithoutFormat(encoder, context, value, type);
        }
    }

    public final T deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super T> type) throws IOException {
        if (this.defaultFormat != null) {
            return (T)((TemporalAccessor)this.defaultFormat.deserialize(decoder, decoderContext, type));
        }
        return this.deserializeNonNullWithoutFormat(decoder, decoderContext, type);
    }

    protected abstract void serializeWithoutFormat(Encoder var1, Serializer.EncoderContext var2, T var3, Argument<? extends T> var4) throws IOException;

    protected abstract T deserializeNonNullWithoutFormat(Decoder var1, Deserializer.DecoderContext var2, Argument<? super T> var3) throws IOException;
}

