/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.util.NullableSerde;
import jakarta.inject.Singleton;
import java.io.IOException;

@Singleton
final class EnumSerde<E extends Enum<E>>
implements NullableSerde<E> {
    EnumSerde() {
    }

    public E deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super E> type) throws IOException {
        Class t = type.getType();
        return (E)Enum.valueOf(t, decoder.decodeString());
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends E> type, E value) throws IOException {
        encoder.encodeString(((Enum)value).name());
    }
}

