/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.support.util.JsonNodeDecoder;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@Internal
public abstract class AbstractStreamDecoder
implements Decoder {
    @Nullable
    AbstractStreamDecoder parent;
    private AbstractStreamDecoder child = null;
    private boolean currentlyUnwrappingArray = false;
    @NonNull
    private final Class<?> view;

    protected AbstractStreamDecoder(@NonNull AbstractStreamDecoder parent) {
        this.parent = parent;
        this.view = parent.view;
    }

    protected AbstractStreamDecoder(@NonNull Class<?> view) {
        this.parent = null;
        this.view = view;
    }

    @Nullable
    protected abstract TokenType currentToken();

    protected abstract void nextToken() throws IOException;

    protected IOException unexpectedToken(TokenType expected) {
        return this.createDeserializationException("Unexpected token " + (Object)((Object)this.currentToken()) + ", expected " + (Object)((Object)expected), null);
    }

    void checkChild() {
        if (this.child != null) {
            throw new IllegalStateException("There is still an unfinished child parser");
        }
        if (this.parent != null && this.parent.child != this) {
            throw new IllegalStateException("This child parser has already completed");
        }
    }

    private void preDecodeValue() {
        this.checkChild();
        if (this.currentToken() == TokenType.KEY) {
            throw new IllegalStateException("Haven't parsed field name yet");
        }
    }

    private boolean beginUnwrapArray() throws IOException {
        if (this.currentlyUnwrappingArray) {
            return false;
        }
        if (this.currentToken() != TokenType.START_ARRAY) {
            throw new IllegalStateException("Not an array");
        }
        this.currentlyUnwrappingArray = true;
        this.nextToken();
        return true;
    }

    private boolean endUnwrapArray() throws IOException {
        this.currentlyUnwrappingArray = false;
        if (this.currentToken() == TokenType.END_ARRAY) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public final void finishStructure() throws IOException {
        this.checkChild();
        TokenType currentToken = this.currentToken();
        if (currentToken != TokenType.END_ARRAY && currentToken != TokenType.END_OBJECT) {
            throw new IllegalStateException("Not all elements have been consumed yet");
        }
        if (this.parent != null) {
            this.transferControlToParent();
        }
    }

    void transferControlToParent() throws IOException {
        this.parent.child = null;
        this.parent.backFromChild(this);
    }

    protected void backFromChild(AbstractStreamDecoder child) throws IOException {
        this.nextToken();
    }

    public final boolean hasNextArrayValue() {
        this.checkChild();
        return this.currentToken() != TokenType.END_ARRAY;
    }

    protected abstract String getCurrentKey() throws IOException;

    @Nullable
    public final String decodeKey() throws IOException {
        this.checkChild();
        TokenType currentToken = this.currentToken();
        if (currentToken == TokenType.END_OBJECT) {
            return null;
        }
        if (currentToken != TokenType.KEY) {
            throw new IllegalStateException("Not at a field name");
        }
        String fieldName = this.getCurrentKey();
        this.nextToken();
        return fieldName;
    }

    protected abstract AbstractStreamDecoder createChildDecoder();

    AbstractStreamDecoder childDecoder() {
        return this.createChildDecoder();
    }

    @NonNull
    public final Decoder decodeArray(Argument<?> type) throws IOException {
        return this.decodeArray0();
    }

    private AbstractStreamDecoder decodeArray0() throws IOException {
        this.preDecodeValue();
        if (this.currentToken() != TokenType.START_ARRAY) {
            throw this.unexpectedToken(TokenType.START_ARRAY);
        }
        this.nextToken();
        this.child = this.childDecoder();
        return this.child;
    }

    @NonNull
    public final Decoder decodeObject(Argument<?> type) throws IOException {
        return this.decodeObject0();
    }

    private AbstractStreamDecoder decodeObject0() throws IOException {
        this.preDecodeValue();
        if (this.currentToken() != TokenType.START_OBJECT) {
            throw this.unexpectedToken(TokenType.START_OBJECT);
        }
        this.nextToken();
        this.child = this.childDecoder();
        return this.child;
    }

    protected abstract String coerceScalarToString() throws IOException;

    @NonNull
    public final String decodeString() throws IOException {
        this.preDecodeValue();
        switch (this.currentToken()) {
            case NUMBER: 
            case STRING: 
            case BOOLEAN: 
            case OTHER: {
                String value = this.coerceScalarToString();
                this.nextToken();
                return value;
            }
            case START_ARRAY: {
                if (!this.beginUnwrapArray()) break;
                String unwrapped = this.decodeString();
                if (this.endUnwrapArray()) {
                    return unwrapped;
                }
                throw this.createDeserializationException("Expected one string, but got array of multiple values", null);
            }
        }
        throw this.unexpectedToken(TokenType.STRING);
    }

    protected abstract boolean getBoolean() throws IOException;

    public final boolean decodeBoolean() throws IOException {
        this.preDecodeValue();
        switch (this.currentToken()) {
            case BOOLEAN: {
                boolean bool = this.getBoolean();
                this.nextToken();
                return bool;
            }
            case NUMBER: {
                double number = this.getDouble();
                this.nextToken();
                return number != 0.0;
            }
            case STRING: {
                String string = this.coerceScalarToString();
                this.nextToken();
                return string.equals("true");
            }
            case START_ARRAY: {
                if (!this.beginUnwrapArray()) break;
                boolean unwrapped = this.decodeBoolean();
                if (!this.endUnwrapArray()) break;
                return unwrapped;
            }
        }
        throw this.unexpectedToken(TokenType.BOOLEAN);
    }

    public final byte decodeByte() throws IOException {
        return (byte)this.decodeInteger(-128L, 127L);
    }

    public final short decodeShort() throws IOException {
        return (short)this.decodeInteger(-32768L, 32767L);
    }

    public final char decodeChar() throws IOException {
        return (char)this.decodeInteger(0L, 65535L, true);
    }

    public final int decodeInt() throws IOException {
        return this.decodeInteger(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public final long decodeLong() throws IOException {
        return this.decodeLong(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    private long decodeLong(long min, long max) throws IOException {
        return this.decodeLong(min, max, false);
    }

    private int decodeInteger(long min, long max) throws IOException {
        return this.decodeInteger(min, max, false);
    }

    protected abstract long getLong() throws IOException;

    protected int getInteger() throws IOException {
        return (int)this.getLong();
    }

    protected abstract double getDouble() throws IOException;

    protected abstract BigInteger getBigInteger() throws IOException;

    protected abstract BigDecimal getBigDecimal() throws IOException;

    protected abstract Number getBestNumber() throws IOException;

    protected JsonNode getBestNumberNode() throws IOException {
        Number number = this.getBestNumber();
        if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
            return JsonNode.createNumberNode((int)number.intValue());
        }
        if (number instanceof Long) {
            return JsonNode.createNumberNode((long)number.longValue());
        }
        if (number instanceof Float) {
            return JsonNode.createNumberNode((float)number.floatValue());
        }
        if (number instanceof Double) {
            return JsonNode.createNumberNode((double)number.doubleValue());
        }
        if (number instanceof BigInteger) {
            return JsonNode.createNumberNode((BigInteger)((BigInteger)number));
        }
        if (number instanceof BigDecimal) {
            return JsonNode.createNumberNode((BigDecimal)((BigDecimal)number));
        }
        return JsonNode.createNumberNode((BigDecimal)this.getBigDecimal());
    }

    private int decodeInteger(long min, long max, boolean stringsAsChars) throws IOException {
        this.preDecodeValue();
        switch (this.currentToken()) {
            case STRING: {
                int value;
                String string = this.coerceScalarToString();
                if (stringsAsChars) {
                    if (string.length() != 1) {
                        throw this.createDeserializationException("When decoding char value, must give a single character", string);
                    }
                    char c = string.charAt(0);
                    this.nextToken();
                    return c;
                }
                try {
                    value = Integer.parseInt(string);
                }
                catch (NumberFormatException e) {
                    throw this.createDeserializationException("Unable to coerce string to integer", string);
                }
                this.nextToken();
                return value;
            }
            case NUMBER: {
                int number = this.getInteger();
                this.nextToken();
                return number;
            }
            case BOOLEAN: {
                boolean bool = this.getBoolean();
                this.nextToken();
                return bool ? 1 : 0;
            }
            case START_ARRAY: {
                if (!this.beginUnwrapArray()) break;
                int unwrapped = this.decodeInteger(min, max);
                if (this.endUnwrapArray()) {
                    return unwrapped;
                }
                throw this.createDeserializationException("Expected one integer, but got array of multiple values", null);
            }
        }
        throw this.unexpectedToken(TokenType.NUMBER);
    }

    private long decodeLong(long min, long max, boolean stringsAsChars) throws IOException {
        this.preDecodeValue();
        switch (this.currentToken()) {
            case STRING: {
                long value;
                String string = this.coerceScalarToString();
                if (stringsAsChars) {
                    if (string.length() != 1) {
                        throw this.createDeserializationException("When decoding char value, must give a single character", string);
                    }
                    char c = string.charAt(0);
                    this.nextToken();
                    return c;
                }
                try {
                    value = Long.parseLong(string);
                }
                catch (NumberFormatException e) {
                    throw this.createDeserializationException("Unable to coerce string to integer", string);
                }
                this.nextToken();
                return value;
            }
            case NUMBER: {
                long number = this.getLong();
                this.nextToken();
                return number;
            }
            case BOOLEAN: {
                boolean bool = this.getBoolean();
                this.nextToken();
                return bool ? 1L : 0L;
            }
            case START_ARRAY: {
                if (!this.beginUnwrapArray()) break;
                long unwrapped = this.decodeLong(min, max);
                if (this.endUnwrapArray()) {
                    return unwrapped;
                }
                throw this.createDeserializationException("Expected one integer, but got array of multiple values", null);
            }
        }
        throw this.unexpectedToken(TokenType.NUMBER);
    }

    public final float decodeFloat() throws IOException {
        return (float)this.decodeDouble();
    }

    public final double decodeDouble() throws IOException {
        this.preDecodeValue();
        switch (this.currentToken()) {
            case NUMBER: {
                double value = this.getDouble();
                this.nextToken();
                return value;
            }
            case STRING: {
                double number;
                String string = this.coerceScalarToString();
                try {
                    number = Double.parseDouble(string);
                }
                catch (NumberFormatException e) {
                    throw this.createDeserializationException("Unable to coerce string to double", string);
                }
                this.nextToken();
                return number;
            }
            case BOOLEAN: {
                boolean bool = this.getBoolean();
                this.nextToken();
                return bool ? 1.0 : 0.0;
            }
            case START_ARRAY: {
                if (!this.beginUnwrapArray()) break;
                double unwrapped = this.decodeDouble();
                if (this.endUnwrapArray()) {
                    return unwrapped;
                }
                throw this.createDeserializationException("Expected one float, but got array of multiple values", null);
            }
        }
        throw this.unexpectedToken(TokenType.NUMBER);
    }

    @NonNull
    public final BigInteger decodeBigInteger() throws IOException {
        BigInteger value;
        this.preDecodeValue();
        switch (this.currentToken()) {
            case NUMBER: {
                value = this.getBigInteger();
                break;
            }
            case STRING: {
                try {
                    value = new BigInteger(this.coerceScalarToString());
                }
                catch (NumberFormatException e) {
                    value = BigInteger.ZERO;
                }
                break;
            }
            case BOOLEAN: {
                value = this.getBoolean() ? BigInteger.ONE : BigInteger.ZERO;
                break;
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray()) {
                    BigInteger unwrapped = this.decodeBigInteger();
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one float, but got array of multiple values", null);
                }
            }
            default: {
                throw this.unexpectedToken(TokenType.NUMBER);
            }
        }
        this.nextToken();
        return value;
    }

    @NonNull
    public final BigDecimal decodeBigDecimal() throws IOException {
        BigDecimal value;
        this.preDecodeValue();
        switch (this.currentToken()) {
            case NUMBER: {
                value = this.getBigDecimal();
                break;
            }
            case STRING: {
                try {
                    value = new BigDecimal(this.coerceScalarToString());
                }
                catch (NumberFormatException e) {
                    value = BigDecimal.ZERO;
                }
                break;
            }
            case BOOLEAN: {
                value = this.getBoolean() ? BigDecimal.ONE : BigDecimal.ZERO;
                break;
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray()) {
                    BigDecimal unwrapped = this.decodeBigDecimal();
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one float, but got array of multiple values", null);
                }
            }
            default: {
                throw this.unexpectedToken(TokenType.NUMBER);
            }
        }
        this.nextToken();
        return value;
    }

    protected final <T> T decodeNumber(ValueDecoder<T> fromNumberToken, Function<String, T> fromString, T zero, T one) throws IOException {
        T value;
        this.preDecodeValue();
        switch (this.currentToken()) {
            case NUMBER: {
                value = fromNumberToken.decode(this);
                break;
            }
            case STRING: {
                try {
                    value = fromString.apply(this.coerceScalarToString());
                }
                catch (NumberFormatException e) {
                    value = zero;
                }
                break;
            }
            case BOOLEAN: {
                value = this.getBoolean() ? one : zero;
                break;
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray()) {
                    T unwrapped = this.decodeNumber(fromNumberToken, fromString, zero, one);
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one float, but got array of multiple values", null);
                }
            }
            default: {
                throw this.unexpectedToken(TokenType.NUMBER);
            }
        }
        this.nextToken();
        return value;
    }

    protected final <T> T decodeCustom(ValueDecoder<T> readFunction) throws IOException {
        return this.decodeCustom(readFunction, true);
    }

    protected final <T> T decodeCustom(ValueDecoder<T> readFunction, boolean callNext) throws IOException {
        this.preDecodeValue();
        T value = readFunction.decode(this);
        if (callNext) {
            this.nextToken();
        }
        return value;
    }

    public final boolean decodeNull() throws IOException {
        this.preDecodeValue();
        if (this.currentToken() == TokenType.NULL) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public Decoder decodeBuffer() throws IOException {
        JsonNode node = this.decodeNode();
        return JsonNodeDecoder.create(node);
    }

    private JsonNode decodeNode() throws IOException {
        switch (this.currentToken()) {
            case START_OBJECT: {
                return AbstractStreamDecoder.decodeObjectNode((AbstractStreamDecoder)this.decodeObject());
            }
            case START_ARRAY: {
                return AbstractStreamDecoder.decodeArrayNode((AbstractStreamDecoder)this.decodeArray());
            }
            case STRING: {
                return JsonNode.createStringNode((String)this.decodeString());
            }
            case NUMBER: {
                this.preDecodeValue();
                JsonNode bestNumberNode = this.getBestNumberNode();
                this.nextToken();
                return bestNumberNode;
            }
            case BOOLEAN: {
                return JsonNode.createBooleanNode((boolean)this.decodeBoolean());
            }
            case NULL: {
                this.decodeNull();
                return JsonNode.nullNode();
            }
        }
        throw this.createDeserializationException("Unexpected token " + (Object)((Object)this.currentToken()) + ", expected value", null);
    }

    private static JsonNode decodeObjectNode(AbstractStreamDecoder elementDecoder) throws IOException {
        String key;
        LinkedHashMap<String, JsonNode> result = new LinkedHashMap<String, JsonNode>();
        while ((key = elementDecoder.decodeKey()) != null) {
            result.put(key, elementDecoder.decodeNode());
        }
        elementDecoder.finishStructure();
        return JsonNode.createObjectNode(result);
    }

    private static JsonNode decodeArrayNode(AbstractStreamDecoder elementDecoder) throws IOException {
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        while (elementDecoder.hasNextArrayValue()) {
            result.add(elementDecoder.decodeNode());
        }
        elementDecoder.finishStructure();
        return JsonNode.createArrayNode(result);
    }

    @Nullable
    public final Object decodeArbitrary() throws IOException {
        RootBuilder root;
        for (ArbitraryBuilder currentStructure = root = new RootBuilder(this); currentStructure != null; currentStructure = currentStructure.proceed()) {
        }
        return root.result;
    }

    protected abstract void skipChildren() throws IOException;

    public final void skipValue() throws IOException {
        this.preDecodeValue();
        this.skipChildren();
        this.nextToken();
    }

    private static final class MapBuilder
    extends ArbitraryBuilder {
        final Map<String, Object> items = new LinkedHashMap<String, Object>();

        MapBuilder(ArbitraryBuilder parent, AbstractStreamDecoder elementDecoder) {
            super(parent, elementDecoder);
        }

        @Override
        void put(String key, Object value) {
            this.items.put(key, value);
        }

        @Override
        String decodeKey() throws IOException {
            String key = this.elementDecoder.decodeKey();
            if (key == null) {
                this.elementDecoder.finishStructure();
            }
            return key;
        }
    }

    private static final class ListBuilder
    extends ArbitraryBuilder {
        final List<Object> items = new ArrayList<Object>();

        ListBuilder(ArbitraryBuilder parent, AbstractStreamDecoder decoder) {
            super(parent, decoder);
        }

        @Override
        void put(String key, Object value) {
            this.items.add(value);
        }

        @Override
        String decodeKey() throws IOException {
            if (this.elementDecoder.hasNextArrayValue()) {
                return "";
            }
            this.elementDecoder.finishStructure();
            return null;
        }
    }

    private static final class RootBuilder
    extends ArbitraryBuilder {
        boolean done = false;
        Object result;

        RootBuilder(AbstractStreamDecoder decoder) {
            super(null, decoder);
        }

        @Override
        void put(String key, Object value) {
            this.result = value;
            this.done = true;
        }

        @Override
        String decodeKey() {
            return !this.done ? "" : null;
        }
    }

    private static abstract class ArbitraryBuilder {
        final ArbitraryBuilder parent;
        final AbstractStreamDecoder elementDecoder;

        ArbitraryBuilder(ArbitraryBuilder parent, AbstractStreamDecoder elementDecoder) {
            this.parent = parent;
            this.elementDecoder = elementDecoder;
        }

        abstract String decodeKey() throws IOException;

        abstract void put(String var1, Object var2);

        ArbitraryBuilder proceed() throws IOException {
            String key = this.decodeKey();
            if (key != null) {
                switch (this.elementDecoder.currentToken()) {
                    case START_OBJECT: {
                        MapBuilder map = new MapBuilder(this, this.elementDecoder.decodeObject0());
                        this.put(key, map.items);
                        return map;
                    }
                    case START_ARRAY: {
                        ListBuilder list = new ListBuilder(this, this.elementDecoder.decodeArray0());
                        this.put(key, list.items);
                        return list;
                    }
                    case STRING: {
                        this.put(key, this.elementDecoder.decodeString());
                        return this;
                    }
                    case NUMBER: {
                        this.elementDecoder.preDecodeValue();
                        this.put(key, this.elementDecoder.getBestNumber());
                        this.elementDecoder.nextToken();
                        return this;
                    }
                    case BOOLEAN: {
                        this.put(key, this.elementDecoder.decodeBoolean());
                        return this;
                    }
                    case NULL: {
                        this.elementDecoder.decodeNull();
                        this.put(key, null);
                        return this;
                    }
                }
                throw this.elementDecoder.createDeserializationException("Unexpected token " + (Object)((Object)this.elementDecoder.currentToken()) + ", expected value", null);
            }
            return this.parent;
        }
    }

    @Internal
    public static interface ValueDecoder<R> {
        public R decode(AbstractStreamDecoder var1) throws IOException;
    }

    protected static enum TokenType {
        START_ARRAY,
        END_ARRAY,
        START_OBJECT,
        END_OBJECT,
        KEY,
        NUMBER,
        STRING,
        BOOLEAN,
        NULL,
        OTHER;

    }
}

