/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.serdes.DefaultFormattedTemporalSerde;
import io.micronaut.serde.support.serdes.TemporalSerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQuery;

@Singleton
public class ZonedDateTimeSerde
extends DefaultFormattedTemporalSerde<ZonedDateTime>
implements TemporalSerde<ZonedDateTime> {
    protected ZonedDateTimeSerde(SerdeConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected DateTimeFormatter getDefaultFormatter() {
        return DateTimeFormatter.ISO_ZONED_DATE_TIME;
    }

    @Override
    public TemporalQuery<ZonedDateTime> query() {
        return ZonedDateTime::from;
    }

    @Override
    protected void serializeWithoutFormat(Encoder encoder, Serializer.EncoderContext context, ZonedDateTime value, Argument<? extends ZonedDateTime> type) throws IOException {
        encoder.encodeLong(value.withZoneSameInstant(UTC).toInstant().toEpochMilli());
    }

    @Override
    protected ZonedDateTime deserializeNonNullWithoutFormat(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super ZonedDateTime> type) throws IOException {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(decoder.decodeLong()), TemporalSerde.UTC);
    }
}

