/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.serdes.ObjectArraySerde;
import io.micronaut.serde.util.NullableSerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.Duration;
import java.time.Period;

@Factory
@BootstrapContextCompatible
public class CoreSerdes {
    @Singleton
    @NonNull
    @BootstrapContextCompatible
    protected Serde<Object[]> objectArraySerde() {
        return new ObjectArraySerde();
    }

    @Singleton
    @NonNull
    @BootstrapContextCompatible
    protected NullableSerde<Duration> durationSerde() {
        return new NullableSerde<Duration>(){

            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Duration> type, Duration value) throws IOException {
                encoder.encodeLong(value.toNanos());
            }

            public Duration deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Duration> type) throws IOException {
                return Duration.ofNanos(decoder.decodeLong());
            }
        };
    }

    @Singleton
    @NonNull
    @BootstrapContextCompatible
    protected NullableSerde<Period> periodSerde() {
        return new NullableSerde<Period>(){

            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Period> type, Period value) throws IOException {
                encoder.encodeString(value.toString());
            }

            public Period deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Period> type) throws IOException {
                return Period.parse(decoder.decodeString());
            }
        };
    }
}

