/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.serdes.DefaultFormattedTemporalSerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;

@Singleton
public class LocalTimeSerde
extends DefaultFormattedTemporalSerde<LocalTime> {
    protected LocalTimeSerde(SerdeConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected DateTimeFormatter getDefaultFormatter() {
        return DateTimeFormatter.ISO_LOCAL_TIME;
    }

    @Override
    public TemporalQuery<LocalTime> query() {
        return TemporalQueries.localTime();
    }

    @Override
    protected void serializeWithoutFormat(Encoder encoder, Serializer.EncoderContext context, LocalTime value, Argument<? extends LocalTime> type) throws IOException {
        encoder.encodeLong(value.toNanoOfDay());
    }

    @Override
    protected LocalTime deserializeNonNullWithoutFormat(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super LocalTime> type) throws IOException {
        return LocalTime.ofNanoOfDay(decoder.decodeLong());
    }
}

