/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serdes.InstantSerde;
import io.micronaut.serde.util.NullableSerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;

@Singleton
final class DateSerde
implements NullableSerde<Date> {
    private static final Argument<Instant> INSTANT_ARGUMENT = Argument.of(Instant.class);
    private final InstantSerde instantSerde;

    DateSerde(InstantSerde instantSerde) {
        this.instantSerde = instantSerde;
    }

    public Serializer<Date> createSpecific(Serializer.EncoderContext encoderContext, Argument<? extends Date> type) {
        Argument argument = Argument.of(Instant.class, (AnnotationMetadata)type.getAnnotationMetadata(), (Argument[])new Argument[0]);
        Serializer specific = this.instantSerde.createSpecific(encoderContext, argument);
        if (specific != this.instantSerde) {
            return (encoder, context, t, value) -> specific.serialize(encoder, context, argument, (Object)value.toInstant());
        }
        return this;
    }

    public Deserializer<Date> createSpecific(Deserializer.DecoderContext decoderContext, Argument<? super Date> context) throws SerdeException {
        Argument argument = Argument.of(Instant.class, (AnnotationMetadata)context.getAnnotationMetadata(), (Argument[])new Argument[0]);
        Deserializer specific = this.instantSerde.createSpecific(decoderContext, argument);
        if (specific != this.instantSerde) {
            return (decoder, subContext, type) -> {
                Instant i = (Instant)specific.deserialize(decoder, subContext, argument);
                if (i != null) {
                    return Date.from(i);
                }
                return null;
            };
        }
        return this;
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Date> type, Date value) throws IOException {
        this.instantSerde.serialize(encoder, context, INSTANT_ARGUMENT, value.toInstant());
    }

    public Date deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Date> type) throws IOException {
        return Date.from((Instant)this.instantSerde.deserializeNonNull(decoder, decoderContext, (Argument)INSTANT_ARGUMENT));
    }
}

