/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.serdes.DefaultFormattedTemporalSerde;
import io.micronaut.serde.support.serdes.TemporalSerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQuery;

@Singleton
public class InstantSerde
extends DefaultFormattedTemporalSerde<Instant>
implements TemporalSerde<Instant> {
    private static final TemporalQuery<Instant> QUERY = Instant::from;

    protected InstantSerde(SerdeConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected DateTimeFormatter getDefaultFormatter() {
        return DateTimeFormatter.ISO_INSTANT;
    }

    @Override
    public TemporalQuery<Instant> query() {
        return QUERY;
    }

    @Override
    protected void serializeWithoutFormat(Encoder encoder, Serializer.EncoderContext context, Instant value, Argument<? extends Instant> type) throws IOException {
        encoder.encodeLong(value.toEpochMilli());
    }

    @Override
    protected Instant deserializeNonNullWithoutFormat(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Instant> type) throws IOException {
        return Instant.ofEpochMilli(decoder.decodeLong());
    }
}

