/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.serdes.DefaultFormattedTemporalSerde;
import io.micronaut.serde.support.serdes.TemporalSerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;

@Singleton
public class LocalDateSerde
extends DefaultFormattedTemporalSerde<LocalDate>
implements TemporalSerde<LocalDate> {
    protected LocalDateSerde(SerdeConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected DateTimeFormatter getDefaultFormatter() {
        return DateTimeFormatter.ISO_LOCAL_DATE;
    }

    @Override
    public TemporalQuery<LocalDate> query() {
        return TemporalQueries.localDate();
    }

    @Override
    protected void serializeWithoutFormat(Encoder encoder, Serializer.EncoderContext context, LocalDate value, Argument<? extends LocalDate> type) throws IOException {
        encoder.encodeLong(value.toEpochDay());
    }

    @Override
    protected LocalDate deserializeNonNullWithoutFormat(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super LocalDate> type) throws IOException {
        return LocalDate.ofEpochDay(decoder.decodeLong());
    }
}

