/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerializationConfiguration;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serializers.CustomizedObjectSerializer;
import io.micronaut.serde.support.serializers.SerBean;
import io.micronaut.serde.support.serializers.SimpleObjectSerializer;
import io.micronaut.serde.support.util.TypeKey;
import io.micronaut.serde.util.CustomizableSerializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@Internal
@Singleton
@Primary
@BootstrapContextCompatible
public final class ObjectSerializer
implements CustomizableSerializer<Object> {
    private final SerdeIntrospections introspections;
    private final SerializationConfiguration configuration;
    private final Map<TypeKey, Supplier<SerBean<Object>>> serBeanMap = new ConcurrentHashMap<TypeKey, Supplier<SerBean<Object>>>(50);

    public ObjectSerializer(SerdeIntrospections introspections, SerializationConfiguration configuration) {
        this.introspections = introspections;
        this.configuration = configuration;
    }

    public Serializer<Object> createSpecific(Serializer.EncoderContext encoderContext, Argument<? extends Object> type) {
        SerBean<Object> serBean;
        if (type.equalsType(Argument.OBJECT_ARGUMENT)) {
            return new RuntimeTypeSerializer(encoderContext);
        }
        try {
            serBean = this.getSerBean(type, encoderContext).get();
        }
        catch (IntrospectionException e) {
            return this.createRuntimeSerializer(encoderContext, type, e);
        }
        AnnotationMetadata annotationMetadata = type.getAnnotationMetadata();
        if (serBean.hasJsonValue()) {
            return new Serializer<Object>(){

                public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<?> type, Object value) throws IOException {
                    serBean.initialize(context);
                    SerBean.SerProperty jsonValue = serBean.jsonValue;
                    Object v = jsonValue.get(value);
                    serBean.jsonValue.serializer.serialize(encoder, context, jsonValue.argument, v);
                }

                public boolean isEmpty(Serializer.EncoderContext context, Object value) {
                    try {
                        serBean.initialize(context);
                    }
                    catch (SerdeException e) {
                        throw new RuntimeException(e);
                    }
                    return serBean.jsonValue.serializer.isEmpty(context, serBean.jsonValue.get(value));
                }

                public boolean isAbsent(Serializer.EncoderContext context, Object value) {
                    try {
                        serBean.initialize(context);
                    }
                    catch (SerdeException e) {
                        throw new RuntimeException(e);
                    }
                    return serBean.jsonValue.serializer.isAbsent(context, serBean.jsonValue.get(value));
                }
            };
        }
        if (annotationMetadata.isAnnotationPresent(SerdeConfig.SerIgnored.class) || annotationMetadata.isAnnotationPresent("PropertyOrder") || annotationMetadata.isAnnotationPresent(SerdeConfig.SerIncluded.class)) {
            Set includedSet;
            Object[] ignored = annotationMetadata.stringValues(SerdeConfig.SerIgnored.class);
            Object[] included = annotationMetadata.stringValues(SerdeConfig.SerIncluded.class);
            final List<String> order = Arrays.asList(annotationMetadata.stringValues("PropertyOrder"));
            final boolean hasIgnored = ArrayUtils.isNotEmpty((Object[])ignored);
            final boolean hasIncluded = ArrayUtils.isNotEmpty((Object[])included);
            final Set ignoreSet = hasIgnored ? CollectionUtils.setOf((Object[])ignored) : null;
            Set set = includedSet = hasIncluded ? CollectionUtils.setOf((Object[])included) : null;
            if (!order.isEmpty() || hasIgnored || hasIncluded) {
                return new CustomizedObjectSerializer<Object>(serBean){

                    @Override
                    protected List<SerBean.SerProperty<Object, Object>> getWriteProperties(SerBean<Object> serBean) {
                        ArrayList<SerBean.SerProperty<Object, Object>> writeProperties = new ArrayList<SerBean.SerProperty<Object, Object>>(super.getWriteProperties(serBean));
                        if (!order.isEmpty()) {
                            writeProperties.sort(Comparator.comparingInt(o -> order.indexOf(o.name)));
                        }
                        if (hasIgnored) {
                            writeProperties.removeIf(p -> ignoreSet.contains(p.name));
                        }
                        if (hasIncluded) {
                            writeProperties.removeIf(p -> !includedSet.contains(p.name));
                        }
                        return writeProperties;
                    }
                };
            }
        }
        Object outer = serBean.simpleBean ? new SimpleObjectSerializer(serBean) : new CustomizedObjectSerializer(serBean);
        if (serBean.subtyped) {
            return new RuntimeTypeSerializer(encoderContext, (Argument)type, (Serializer)outer){
                final /* synthetic */ Argument val$type;
                final /* synthetic */ Serializer val$outer;
                {
                    this.val$type = argument;
                    this.val$outer = serializer;
                    super(encoderContext);
                }

                @Override
                protected Serializer<Object> tryToFindSerializer(Serializer.EncoderContext context, Object value) throws SerdeException {
                    if (value.getClass().equals(this.val$type.getType())) {
                        return this.val$outer;
                    }
                    return super.tryToFindSerializer(context, value);
                }
            };
        }
        return outer;
    }

    private Supplier<SerBean<Object>> getSerBean(Argument<? extends Object> type, Serializer.EncoderContext context) {
        TypeKey key = new TypeKey(type);
        Supplier serBeanSupplier = this.serBeanMap.get(key);
        if (serBeanSupplier == null) {
            serBeanSupplier = SupplierUtil.memoized(() -> this.create(type, context));
            this.serBeanMap.put(key, serBeanSupplier);
        }
        return serBeanSupplier;
    }

    private SerBean<Object> create(Argument<? extends Object> type, Serializer.EncoderContext encoderContext) {
        try {
            return new SerBean<Object>(type, this.introspections, encoderContext, this.configuration);
        }
        catch (SerdeException e) {
            throw new IntrospectionException("Error creating deserializer for type [" + type + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    private Serializer<Object> createRuntimeSerializer(Serializer.EncoderContext encoderContext, final Argument<? extends Object> type, final IntrospectionException e) {
        return new RuntimeTypeSerializer(encoderContext){

            @Override
            protected Serializer<Object> tryToFindSerializer(Serializer.EncoderContext context, Object value) throws SerdeException {
                Class<?> theType = value.getClass();
                if (!theType.equals(type.getType())) {
                    return super.tryToFindSerializer(context, value);
                }
                throw new SerdeException(e.getMessage(), (Throwable)e);
            }
        };
    }

    private static class RuntimeTypeSerializer
    implements Serializer<Object> {
        private final Serializer.EncoderContext encoderContext;
        private final Map<Class<?>, Serializer<Object>> inners = new ConcurrentHashMap(10);

        public RuntimeTypeSerializer(Serializer.EncoderContext encoderContext) {
            this.encoderContext = encoderContext;
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<?> type, Object value) throws IOException {
            if (value == null) {
                encoder.encodeNull();
            } else {
                Argument arg = Argument.of(value.getClass());
                this.getSerializer(context, value).serialize(encoder, context, arg, value);
            }
        }

        public boolean isEmpty(Serializer.EncoderContext context, Object value) {
            if (value == null) {
                return true;
            }
            try {
                return this.getSerializer(context, value).isEmpty(context, value);
            }
            catch (SerdeException serdeException) {
                return super.isEmpty(context, value);
            }
        }

        public boolean isAbsent(Serializer.EncoderContext context, Object value) {
            if (value == null) {
                return true;
            }
            try {
                return this.getSerializer(context, value).isAbsent(context, value);
            }
            catch (SerdeException serdeException) {
                return super.isAbsent(context, value);
            }
        }

        private Serializer<Object> getSerializer(Serializer.EncoderContext context, Object value) throws SerdeException {
            try {
                return this.inners.computeIfAbsent(value.getClass(), t -> {
                    try {
                        return this.tryToFindSerializer(context, value);
                    }
                    catch (SerdeException ex) {
                        throw new IntrospectionException("No serializer found for type: " + value.getClass(), (Throwable)ex);
                    }
                });
            }
            catch (IntrospectionException e) {
                if (e.getCause() instanceof SerdeException) {
                    throw (SerdeException)e.getCause();
                }
                throw e;
            }
        }

        protected Serializer<Object> tryToFindSerializer(Serializer.EncoderContext context, Object value) throws SerdeException {
            Argument arg = Argument.of(value.getClass());
            return this.encoderContext.findSerializer(arg).createSpecific(context, arg);
        }
    }
}

