/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import java.io.IOException;
import java.util.Locale;

final class EnumCreatorDeserializer<E extends Enum<E>>
implements Deserializer<E> {
    Argument<Object> argumentType;
    Deserializer<Object> argumentDeserializer;
    BeanIntrospection<? super E> deserializableIntrospection;

    public EnumCreatorDeserializer(Argument<Object> argumentType, Deserializer<Object> argumentDeserializer, BeanIntrospection<? super E> deserializableIntrospection) {
        this.argumentType = argumentType;
        this.argumentDeserializer = argumentDeserializer;
        this.deserializableIntrospection = deserializableIntrospection;
    }

    public E deserialize(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super E> type) throws IOException {
        Object v = this.argumentDeserializer.deserialize(decoder, context, this.argumentType);
        try {
            return (E)((Enum)this.deserializableIntrospection.instantiate(new Object[]{v}));
        }
        catch (IllegalArgumentException e) {
            if (v instanceof String) {
                String string = (String)v;
                try {
                    return (E)((Enum)this.deserializableIntrospection.instantiate(new Object[]{string.toUpperCase(Locale.ENGLISH)}));
                }
                catch (IllegalArgumentException ex) {
                    throw e;
                }
            }
            throw e;
        }
    }

    public boolean allowNull() {
        return this.argumentDeserializer.allowNull();
    }
}

