/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.reference.PropertyReference;
import io.micronaut.serde.reference.SerializationReference;
import io.micronaut.serde.support.serializers.SerBean;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@Internal
public class CustomizedObjectSerializer<T>
implements Serializer<T> {
    private final SerBean<Object> serBean;

    public CustomizedObjectSerializer(SerBean<Object> serBean) {
        this.serBean = serBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        try {
            Map map;
            Object data;
            this.serBean.initialize(context);
            Encoder childEncoder = encoder.encodeObject(type);
            if (this.serBean.wrapperProperty != null) {
                childEncoder.encodeKey(this.serBean.wrapperProperty);
                childEncoder = childEncoder.encodeObject(type);
            }
            block12: for (SerBean.SerProperty<Object, Object> property : this.getWriteProperties(this.serBean)) {
                SerializationReference ref;
                Object v = property.get(value);
                String backRef = property.backRef;
                if (backRef != null && (ref = context.resolveReference(new SerializationReference(backRef, this.serBean.introspection, property.argument, v, property.serializer))) == null) continue;
                Serializer serializer = property.serializer;
                if (this.serBean.propertyFilter != null) {
                    if (!this.serBean.propertyFilter.shouldInclude(context, serializer, value, property.name, v)) {
                        continue;
                    }
                } else {
                    switch (property.include) {
                        case NON_NULL: {
                            if (v != null) break;
                            continue block12;
                        }
                        case NON_ABSENT: {
                            if (!serializer.isAbsent(context, v)) break;
                            continue block12;
                        }
                        case NON_EMPTY: {
                            if (!serializer.isEmpty(context, v)) break;
                            continue block12;
                        }
                        case NEVER: {
                            continue block12;
                        }
                    }
                }
                if (property.views != null && !context.hasView((Class[])property.views)) continue;
                String managedRef = property.managedRef;
                if (managedRef != null) {
                    context.pushManagedRef((PropertyReference)new SerializationReference(managedRef, this.serBean.introspection, property.argument, value, property.serializer));
                }
                try {
                    childEncoder.encodeKey(property.name);
                    if (v == null) {
                        childEncoder.encodeNull();
                        continue;
                    }
                    serializer.serialize(childEncoder, context, property.argument, v);
                }
                finally {
                    if (managedRef == null) continue;
                    context.popManagedRef();
                }
            }
            SerBean.SerProperty anyGetter = this.serBean.anyGetter;
            if (anyGetter != null && (data = anyGetter.get(value)) instanceof Map && CollectionUtils.isNotEmpty((Map)(map = (Map)data))) {
                for (Object k : map.keySet()) {
                    Object v = map.get(k);
                    childEncoder.encodeKey(k.toString());
                    if (v == null) {
                        childEncoder.encodeNull();
                        continue;
                    }
                    Argument valueType = anyGetter.argument.getTypeVariable("V").orElse(null);
                    if (valueType == null || valueType.equalsType(Argument.OBJECT_ARGUMENT)) {
                        valueType = Argument.of(v.getClass());
                    }
                    Serializer serializer = context.findSerializer(valueType);
                    serializer.serialize(childEncoder, context, valueType, v);
                }
            }
            childEncoder.finishStructure();
        }
        catch (StackOverflowError e) {
            throw new SerdeException("Infinite recursion serializing type: " + type.getType().getSimpleName() + " at path " + encoder.currentPath(), (Throwable)e);
        }
        catch (IntrospectionException e) {
            throw new SerdeException("Error serializing value at path: " + encoder.currentPath() + ". No serializer found for type: " + type, (Throwable)e);
        }
    }

    @NonNull
    protected List<SerBean.SerProperty<Object, Object>> getWriteProperties(SerBean<Object> serBean) {
        return serBean.writeProperties;
    }
}

