/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.util.CustomizableDeserializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

@Factory
public class CoreDeserializers {
    @Singleton
    @Order(value=-100)
    @NonNull
    protected <E> Deserializer<ArrayList<E>> arrayListDeserializer() {
        return new ArrayListCollectionDeserializer();
    }

    @Singleton
    @Order(value=-99)
    @NonNull
    protected <E> Deserializer<ArrayDeque<E>> arrayDequeDeserializer() {
        return new ArrayDequeDeserializer();
    }

    @Singleton
    @Order(value=-99)
    @NonNull
    protected <E> Deserializer<LinkedList<E>> linkedListDeserializer() {
        return new LinkedListDeserializer();
    }

    @NonNull
    @Singleton
    @Order(value=-50)
    protected <E> Deserializer<HashSet<E>> hashSetDeserializer() {
        return new HashSetDeserializer();
    }

    @NonNull
    @Singleton
    protected <E> Deserializer<? extends Set<E>> defaultSetDeserializer() {
        return new HashSetDeserializer();
    }

    @NonNull
    @Singleton
    @Order(value=-51)
    protected <E> Deserializer<LinkedHashSet<E>> linkedHashSetDeserializer() {
        return new LinkedHashDeserializer();
    }

    @NonNull
    @Singleton
    @Order(value=-52)
    protected <E> Deserializer<TreeSet<E>> treeSetDeserializer() {
        return new TreeSetDeserializer();
    }

    @Singleton
    @NonNull
    @Order(value=1001)
    protected <K, V> Deserializer<LinkedHashMap<K, V>> linkedHashMapDeserializer() {
        return new LinkedHashMapDeserializer();
    }

    @Singleton
    @NonNull
    @Order(value=1002)
    protected <K, V> Deserializer<TreeMap<K, V>> treeMapDeserializer() {
        return new TreeMapDeserializer();
    }

    @Singleton
    @NonNull
    protected <V> Deserializer<Optional<V>> optionalDeserializer() {
        return new OptionalDeserializer();
    }

    private static abstract class SpecificOnlyCollectionDeserializer<E, C extends Collection<E>>
    implements CustomizableDeserializer<C> {
        private SpecificOnlyCollectionDeserializer() {
        }

        public Deserializer<C> createSpecific(Deserializer.DecoderContext context, Argument<? super C> type) throws SerdeException {
            Object[] generics = type.getTypeParameters();
            if (ArrayUtils.isEmpty((Object[])generics)) {
                throw new SerdeException("Cannot deserialize raw list");
            }
            Object collectionItemArgument = generics[0];
            final Deserializer valueDeser = context.findDeserializer((Argument)collectionItemArgument).createSpecific(context, (Argument)collectionItemArgument);
            return new Deserializer<C>((Argument)collectionItemArgument){
                final /* synthetic */ Argument val$collectionItemArgument;
                {
                    this.val$collectionItemArgument = argument;
                }

                public C deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super C> type) throws IOException {
                    if (decoder.decodeNull()) {
                        return null;
                    }
                    Decoder arrayDecoder = decoder.decodeArray();
                    Object collection = this.getDefaultValue(decoderContext, type);
                    while (arrayDecoder.hasNextArrayValue()) {
                        collection.add(valueDeser.deserialize(arrayDecoder, decoderContext, this.val$collectionItemArgument));
                    }
                    arrayDecoder.finishStructure();
                    return collection;
                }

                public boolean allowNull() {
                    return true;
                }

                @NonNull
                public C getDefaultValue(Deserializer.DecoderContext context, Argument<? super C> type) {
                    return this.getDefaultValue();
                }
            };
        }

        @NonNull
        abstract C getDefaultValue();
    }

    private static class ArrayListCollectionDeserializer<E>
    extends SpecificOnlyCollectionDeserializer<E, ArrayList<E>> {
        private ArrayListCollectionDeserializer() {
        }

        @Override
        public ArrayList<E> getDefaultValue() {
            return new ArrayList();
        }
    }

    private static class TreeSetDeserializer<E>
    extends SpecificOnlyCollectionDeserializer<E, TreeSet<E>> {
        private TreeSetDeserializer() {
        }

        @Override
        public TreeSet<E> getDefaultValue() {
            return new TreeSet();
        }
    }

    private static class LinkedHashDeserializer<E>
    extends SpecificOnlyCollectionDeserializer<E, LinkedHashSet<E>> {
        private LinkedHashDeserializer() {
        }

        @Override
        public LinkedHashSet<E> getDefaultValue() {
            return new LinkedHashSet();
        }
    }

    private static class HashSetDeserializer<E>
    extends SpecificOnlyCollectionDeserializer<E, HashSet<E>> {
        private HashSetDeserializer() {
        }

        @Override
        public HashSet<E> getDefaultValue() {
            return new HashSet();
        }
    }

    private static class LinkedListDeserializer<E>
    extends SpecificOnlyCollectionDeserializer<E, LinkedList<E>> {
        private LinkedListDeserializer() {
        }

        @Override
        public LinkedList<E> getDefaultValue() {
            return new LinkedList();
        }
    }

    private static class ArrayDequeDeserializer<E>
    extends SpecificOnlyCollectionDeserializer<E, ArrayDeque<E>> {
        private ArrayDequeDeserializer() {
        }

        @Override
        public ArrayDeque<E> getDefaultValue() {
            return new ArrayDeque();
        }
    }

    private static abstract class SpecificOnlyMapDeserializer<K, V, M extends Map<K, V>>
    implements CustomizableDeserializer<M> {
        private SpecificOnlyMapDeserializer() {
        }

        public Deserializer<M> createSpecific(Deserializer.DecoderContext context, Argument<? super M> type) throws SerdeException {
            Argument[] generics = type.getTypeParameters();
            if (generics.length == 2) {
                final Argument keyType = generics[0];
                final Argument valueType = generics[1];
                final Deserializer valueDeser = valueType.equalsType(Argument.OBJECT_ARGUMENT) ? null : context.findDeserializer(valueType).createSpecific(context, valueType);
                return new Deserializer<M>(){

                    public M deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super M> type) throws IOException {
                        if (decoder.decodeNull()) {
                            return null;
                        }
                        Decoder objectDecoder = decoder.decodeObject(type);
                        String key = objectDecoder.decodeKey();
                        Object map = this.getDefaultValue(decoderContext, type);
                        ConversionService conversionService = decoderContext.getConversionService();
                        while (key != null) {
                            Object k;
                            if (keyType.isInstance((Object)key)) {
                                k = key;
                            } else {
                                try {
                                    k = conversionService.convertRequired((Object)key, keyType);
                                }
                                catch (ConversionErrorException e) {
                                    throw new SerdeException("Error converting Map key [" + key + "] to target type [" + keyType + "]: " + e.getMessage(), (Throwable)e);
                                }
                            }
                            if (valueDeser == null) {
                                map.put(k, objectDecoder.decodeArbitrary());
                            } else {
                                map.put(k, valueDeser.deserialize(objectDecoder, decoderContext, valueType));
                            }
                            key = objectDecoder.decodeKey();
                        }
                        objectDecoder.finishStructure();
                        return map;
                    }

                    public boolean allowNull() {
                        return true;
                    }

                    public M getDefaultValue(Deserializer.DecoderContext context, Argument<? super M> type) {
                        return this.getDefaultValue();
                    }
                };
            }
            return new Deserializer<M>(){

                public M deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super M> type) throws IOException {
                    if (decoder.decodeNull()) {
                        return null;
                    }
                    Object o = decoder.decodeArbitrary();
                    if (type.isInstance(o)) {
                        return (Map)o;
                    }
                    if (o instanceof Map) {
                        Object map = this.getDefaultValue(decoderContext, type);
                        map.putAll((Map)o);
                        return map;
                    }
                    throw new SerdeException("Cannot deserialize map of type [" + type + "] from value: " + o);
                }

                public M getDefaultValue(Deserializer.DecoderContext context, Argument<? super M> type) {
                    return this.getDefaultValue();
                }
            };
        }

        @NonNull
        abstract M getDefaultValue();
    }

    private static class TreeMapDeserializer<K, V>
    extends SpecificOnlyMapDeserializer<K, V, TreeMap<K, V>> {
        private TreeMapDeserializer() {
        }

        @Override
        public TreeMap<K, V> getDefaultValue() {
            return new TreeMap();
        }
    }

    private static class LinkedHashMapDeserializer<K, V>
    extends SpecificOnlyMapDeserializer<K, V, LinkedHashMap<K, V>> {
        private LinkedHashMapDeserializer() {
        }

        @Override
        public LinkedHashMap<K, V> getDefaultValue() {
            return new LinkedHashMap();
        }
    }

    private static class OptionalDeserializer<V>
    implements CustomizableDeserializer<Optional<V>> {
        private OptionalDeserializer() {
        }

        public Deserializer<Optional<V>> createSpecific(Deserializer.DecoderContext context, Argument<? super Optional<V>> type) throws SerdeException {
            final Argument generic = type.getFirstTypeVariable().orElse(null);
            if (generic == null) {
                throw new SerdeException("Cannot deserialize raw optional");
            }
            final Deserializer deserializer = context.findDeserializer(generic).createSpecific(context, generic);
            return new Deserializer<Optional<V>>(){

                public Optional<V> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super Optional<V>> type) throws IOException {
                    if (decoder.decodeNull()) {
                        return Optional.empty();
                    }
                    return Optional.ofNullable(deserializer.deserialize(decoder, context, generic));
                }

                public Optional<V> getDefaultValue(Deserializer.DecoderContext context, Argument<? super Optional<V>> type) {
                    return Optional.empty();
                }
            };
        }
    }
}

