/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serdes.LocalDateSerde;
import io.micronaut.serde.util.NullableSerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.sql.Date;
import java.time.LocalDate;

@Singleton
@Secondary
final class SqlDateSerde
implements NullableSerde<Date> {
    private static final Argument<LocalDate> LOCAL_DATE_ARGUMENT = Argument.of(LocalDate.class);
    private final LocalDateSerde localDateSerde;

    SqlDateSerde(LocalDateSerde localDateSerde) {
        this.localDateSerde = localDateSerde;
    }

    public Deserializer<Date> createSpecific(Deserializer.DecoderContext decoderContext, Argument<? super Date> context) throws SerdeException {
        Argument argument = Argument.of(LocalDate.class, (AnnotationMetadata)context.getAnnotationMetadata(), (Argument[])new Argument[0]);
        Deserializer specific = this.localDateSerde.createSpecific(decoderContext, argument);
        if (specific != this.localDateSerde) {
            return (decoder, subContext, type) -> {
                LocalDate ld = (LocalDate)specific.deserialize(decoder, subContext, argument);
                if (ld != null) {
                    return Date.valueOf(ld);
                }
                return null;
            };
        }
        return this;
    }

    public Serializer<Date> createSpecific(Serializer.EncoderContext encoderContext, Argument<? extends Date> type) {
        Argument argument = Argument.of(LocalDate.class, (AnnotationMetadata)type.getAnnotationMetadata(), (Argument[])new Argument[0]);
        Serializer specific = this.localDateSerde.createSpecific(encoderContext, argument);
        if (specific != this.localDateSerde) {
            return (encoder, context, t, value) -> specific.serialize(encoder, context, argument, (Object)value.toLocalDate());
        }
        return this;
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Date> type, Date value) throws IOException {
        this.localDateSerde.serialize(encoder, context, LOCAL_DATE_ARGUMENT, value.toLocalDate());
    }

    public Date deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Date> type) throws IOException {
        LocalDate localDate = (LocalDate)this.localDateSerde.deserialize(decoder, decoderContext, LOCAL_DATE_ARGUMENT);
        if (localDate != null) {
            return Date.valueOf(localDate);
        }
        return null;
    }
}

