/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serdes.FormattedTemporalSerde;
import io.micronaut.serde.util.NullableSerde;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;

public interface TemporalSerde<T extends TemporalAccessor>
extends NullableSerde<T> {
    public static final ZoneId UTC = ZoneId.of(ZoneOffset.UTC.getId());

    default public Serializer<T> createSpecific(Serializer.EncoderContext context, Argument<? extends T> type) {
        AnnotationMetadata annotationMetadata = type.getAnnotationMetadata();
        String pattern = annotationMetadata.stringValue(SerdeConfig.class, "pattern").orElse(null);
        if (pattern != null) {
            return new FormattedTemporalSerde<T>(pattern, annotationMetadata, this.query());
        }
        return this;
    }

    default public Deserializer<T> createSpecific(Deserializer.DecoderContext decoderContext, Argument<? super T> context) throws SerdeException {
        AnnotationMetadata annotationMetadata = context.getAnnotationMetadata();
        String pattern = annotationMetadata.stringValue(SerdeConfig.class, "pattern").orElse(null);
        if (pattern != null) {
            return new FormattedTemporalSerde<T>(pattern, annotationMetadata, this.query());
        }
        return this;
    }

    @NonNull
    public TemporalQuery<T> query();
}

