/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serde;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.DefaultDecoderContext;
import io.micronaut.serde.support.DefaultEncoderContext;
import io.micronaut.serde.support.deserializers.ObjectDeserializer;
import io.micronaut.serde.support.serdes.NumberSerde;
import io.micronaut.serde.support.serializers.ObjectSerializer;
import io.micronaut.serde.support.util.TypeKey;
import io.micronaut.serde.util.NullableSerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Singleton
@BootstrapContextCompatible
public class DefaultSerdeRegistry
implements SerdeRegistry {
    public static final IntegerSerde INTEGER_SERDE = new IntegerSerde();
    public static final LongSerde LONG_SERDE = new LongSerde();
    public static final ShortSerde SHORT_SERDE = new ShortSerde();
    public static final FloatSerde FLOAT_SERDE = new FloatSerde();
    public static final ByteSerde BYTE_SERDE = new ByteSerde();
    public static final DoubleSerde DOUBLE_SERDE = new DoubleSerde();
    public static final OptionalIntSerde OPTIONAL_INT_SERDE = new OptionalIntSerde();
    public static final OptionalDoubleSerde OPTIONAL_DOUBLE_SERDE = new OptionalDoubleSerde();
    public static final OptionalLongSerde OPTIONAL_LONG_SERDE = new OptionalLongSerde();
    public static final BigDecimalSerde BIG_DECIMAL_SERDE = new BigDecimalSerde();
    public static final BigIntegerSerde BIG_INTEGER_SERDE = new BigIntegerSerde();
    public static final UUIDSerde UUID_SERDE = new UUIDSerde();
    public static final URLSerde URL_SERDE = new URLSerde();
    public static final URISerde URI_SERDE = new URISerde();
    public static final CharsetSerde CHARSET_SERDE = new CharsetSerde();
    public static final TimeZoneSerde TIME_ZONE_SERDE = new TimeZoneSerde();
    public static final LocaleSerde LOCALE_SERDE = new LocaleSerde();
    public static final IntArraySerde INT_ARRAY_SERDE = new IntArraySerde();
    public static final LongArraySerde LONG_ARRAY_SERDE = new LongArraySerde();
    public static final FloatArraySerde FLOAT_ARRAY_SERDE = new FloatArraySerde();
    public static final ShortArraySerde SHORT_ARRAY_SERDE = new ShortArraySerde();
    public static final DoubleArraySerde DOUBLE_ARRAY_SERDE = new DoubleArraySerde();
    public static final BooleanArraySerde BOOLEAN_ARRAY_SERDE = new BooleanArraySerde();
    public static final ByteArraySerde BYTE_ARRAY_SERDE = new ByteArraySerde();
    public static final CharArraySerde CHAR_ARRAY_SERDE = new CharArraySerde();
    public static final StringSerde STRING_SERDE = new StringSerde();
    public static final BooleanSerde BOOLEAN_SERDE = new BooleanSerde();
    public static final CharSerde CHAR_SERDE = new CharSerde();
    public static final List<SerdeRegistrar<?>> DEFAULT_SERDES = List.of(BOOLEAN_SERDE, BYTE_SERDE, CHAR_SERDE, DOUBLE_SERDE, FLOAT_SERDE, INTEGER_SERDE, LONG_SERDE, SHORT_SERDE, STRING_SERDE, OPTIONAL_INT_SERDE, OPTIONAL_DOUBLE_SERDE, OPTIONAL_LONG_SERDE, BIG_DECIMAL_SERDE, BIG_INTEGER_SERDE, UUID_SERDE, URL_SERDE, URI_SERDE, CHARSET_SERDE, TIME_ZONE_SERDE, LOCALE_SERDE, INT_ARRAY_SERDE, LONG_ARRAY_SERDE, FLOAT_ARRAY_SERDE, SHORT_ARRAY_SERDE, DOUBLE_ARRAY_SERDE, BOOLEAN_ARRAY_SERDE, BYTE_ARRAY_SERDE, CHAR_ARRAY_SERDE);
    private final Serializer<Object> objectSerializer;
    private final Map<Class<?>, List<BeanDefinition<Serializer>>> serializerDefMap;
    private final Map<Class<?>, List<BeanDefinition<Deserializer>>> deserializerDefMap;
    private final Map<TypeKey, Serializer<?>> serializerMap = new ConcurrentHashMap(50);
    private final Map<TypeKey, Deserializer<?>> deserializerMap = new ConcurrentHashMap(50);
    private final BeanContext beanContext;
    private final SerdeIntrospections introspections;
    private final Deserializer<Object> objectDeserializer;
    private final Serde<Object[]> objectArraySerde;
    private final ConversionService conversionService;

    public DefaultSerdeRegistry(BeanContext beanContext, ObjectSerializer objectSerializer, ObjectDeserializer objectDeserializer, Serde<Object[]> objectArraySerde, SerdeIntrospections introspections, ConversionService conversionService) {
        Class primitiveType;
        Class t;
        Argument argument;
        List typeArguments;
        Collection serializers = beanContext.getBeanDefinitions(Serializer.class);
        Collection deserializers = beanContext.getBeanDefinitions(Deserializer.class);
        this.introspections = introspections;
        this.serializerDefMap = new HashMap(serializers.size() + 30);
        this.deserializerDefMap = new HashMap(deserializers.size() + 30);
        this.objectArraySerde = objectArraySerde;
        this.beanContext = beanContext;
        for (BeanDefinition serializer : serializers) {
            typeArguments = serializer.getTypeArguments(Serializer.class);
            if (CollectionUtils.isNotEmpty((Collection)typeArguments)) {
                argument = (Argument)typeArguments.iterator().next();
                if (argument.equalsType(Argument.OBJECT_ARGUMENT)) continue;
                t = argument.getType();
                this.serializerDefMap.computeIfAbsent(t, aClass -> new ArrayList(5)).add(serializer);
                primitiveType = ReflectionUtils.getPrimitiveType((Class)t);
                if (primitiveType == t) continue;
                this.serializerDefMap.computeIfAbsent(primitiveType, aClass -> new ArrayList(5)).add(serializer);
                continue;
            }
            throw new ConfigurationException("Serializer without generic types defined: " + serializer.getBeanType());
        }
        for (BeanDefinition deserializer : deserializers) {
            typeArguments = deserializer.getTypeArguments(Deserializer.class);
            if (CollectionUtils.isNotEmpty((Collection)typeArguments)) {
                argument = (Argument)typeArguments.iterator().next();
                if (argument.equalsType(Argument.OBJECT_ARGUMENT)) continue;
                t = argument.getType();
                this.deserializerDefMap.computeIfAbsent(t, aClass -> new ArrayList(5)).add(deserializer);
                primitiveType = ReflectionUtils.getPrimitiveType((Class)t);
                if (primitiveType == t) continue;
                this.deserializerDefMap.computeIfAbsent(primitiveType, aClass -> new ArrayList(5)).add(deserializer);
                continue;
            }
            throw new ConfigurationException("Deserializer without generic types defined: " + deserializer.getBeanType());
        }
        this.registerBuiltInSerdes();
        this.objectSerializer = objectSerializer;
        this.objectDeserializer = objectDeserializer;
        this.conversionService = conversionService;
    }

    private void registerBuiltInSerdes() {
        DEFAULT_SERDES.forEach(this::register);
    }

    private void register(SerdeRegistrar<?> serdeRegistrar) {
        for (Argument<?> type : serdeRegistrar.getTypes()) {
            TypeKey typeEntry = new TypeKey(type);
            if (!this.deserializerDefMap.containsKey(type.getType())) {
                this.deserializerMap.put(typeEntry, (Deserializer<?>)serdeRegistrar);
            }
            if (this.serializerDefMap.containsKey(type.getType())) continue;
            this.serializerMap.put(typeEntry, (Serializer<?>)serdeRegistrar);
        }
    }

    public <T, D extends Serializer<? extends T>> D findCustomSerializer(Class<? extends D> serializerClass) throws SerdeException {
        return (D)((Serializer)this.beanContext.findBean(serializerClass).orElseThrow(() -> new SerdeException("Cannot find serializer: " + serializerClass)));
    }

    public <T, D extends Deserializer<? extends T>> D findCustomDeserializer(Class<? extends D> deserializerClass) throws SerdeException {
        return (D)((Deserializer)this.beanContext.findBean(deserializerClass).orElseThrow(() -> new SerdeException("Cannot find deserializer: " + deserializerClass)));
    }

    public <D extends PropertyNamingStrategy> D findNamingStrategy(Class<? extends D> namingStrategyClass) throws SerdeException {
        return (D)((PropertyNamingStrategy)this.beanContext.findBean(namingStrategyClass).orElseThrow(() -> new SerdeException("Cannot find naming strategy: " + namingStrategyClass)));
    }

    public <T> Deserializer<? extends T> findDeserializer(Argument<? extends T> type) {
        Objects.requireNonNull(type, "Type cannot be null");
        TypeKey key = new TypeKey(type);
        Deserializer<?> deserializer = this.deserializerMap.get(key);
        if (deserializer != null) {
            return deserializer;
        }
        Argument deserializerArgument = Argument.of(Deserializer.class, (Argument[])new Argument[]{type});
        Collection beanRegistrations = this.beanContext.getBeanRegistrations(deserializerArgument, null);
        Deserializer deser = null;
        if (beanRegistrations.size() == 1) {
            deser = (Deserializer)((BeanRegistration)beanRegistrations.iterator().next()).bean();
        } else if (!beanRegistrations.isEmpty()) {
            List results = beanRegistrations.stream().filter(r -> {
                Class[] typeParameters = r.getBeanDefinition().getTypeParameters(Deserializer.class);
                return typeParameters.length == 1 && typeParameters[0].equals(type.getType());
            }).collect(Collectors.toList());
            deser = results.size() == 1 ? (Deserializer)((BeanRegistration)results.iterator().next()).bean() : (Deserializer)this.beanContext.findBean(deserializerArgument).orElse(null);
        }
        if (deser != null) {
            this.deserializerMap.put(key, deser);
            return deser;
        }
        if (key.getType().isArray()) {
            this.deserializerMap.put(key, (Deserializer<?>)this.objectArraySerde);
            return this.objectArraySerde;
        }
        this.deserializerMap.put(key, this.objectDeserializer);
        return this.objectDeserializer;
    }

    public <T> Collection<BeanIntrospection<? extends T>> getDeserializableSubtypes(Class<T> superType) {
        return this.introspections.findSubtypeDeserializables(superType);
    }

    public <T> Serializer<? super T> findSerializer(Argument<? extends T> type) throws SerdeException {
        Objects.requireNonNull(type, "Type cannot be null");
        TypeKey key = new TypeKey(type);
        Serializer<?> serializer = this.serializerMap.get(key);
        if (serializer != null) {
            return serializer;
        }
        List<BeanDefinition<Serializer>> possibles = this.serializerDefMap.get(type.getType());
        if (possibles == null) {
            for (Map.Entry<Class<?>, List<BeanDefinition<Serializer>>> entry : this.serializerDefMap.entrySet()) {
                Class<?> targetType = entry.getKey();
                if (!targetType.isAssignableFrom(type.getType())) continue;
                possibles = entry.getValue();
                Object[] params = type.getTypeParameters();
                if (!ArrayUtils.isNotEmpty((Object[])params)) break;
                possibles = new ArrayList<BeanDefinition<Serializer>>(possibles);
                Iterator<BeanDefinition<Serializer>> i = possibles.iterator();
                while (i.hasNext()) {
                    BeanDefinition<Serializer> bd = i.next();
                    Argument[] candidateParams = ((Argument)bd.getTypeArguments(Serializer.class).get(0)).getTypeParameters();
                    if (candidateParams.length == params.length) {
                        for (int j = 0; j < params.length; ++j) {
                            Object param = params[j];
                            Argument candidateParam = candidateParams[j];
                            if (param.getType() == candidateParam.getType() || candidateParam.isTypeVariable() && candidateParam.getType().isAssignableFrom(param.getType())) continue;
                            i.remove();
                        }
                        continue;
                    }
                    i.remove();
                }
                break block0;
            }
        }
        if (possibles != null) {
            Serializer locatedSerializer;
            BeanDefinition<Serializer> definition;
            if (possibles.size() == 1) {
                definition = possibles.iterator().next();
                locatedSerializer = (Serializer)this.beanContext.getBean(definition);
                this.serializerMap.put(key, locatedSerializer);
                return locatedSerializer;
            }
            if (possibles.isEmpty()) {
                throw new SerdeException("No serializers found for type: " + type);
            }
            definition = this.lastChanceResolve(type, possibles);
            locatedSerializer = (Serializer)this.beanContext.getBean(definition);
            this.serializerMap.put(key, locatedSerializer);
            return locatedSerializer;
        }
        this.serializerMap.put(key, this.objectSerializer);
        return this.objectSerializer;
    }

    private BeanDefinition<Serializer> lastChanceResolve(Argument<?> type, Collection<BeanDefinition<Serializer>> candidates) throws SerdeException {
        List primary;
        if (candidates.size() > 1 && !(primary = candidates.stream().filter(BeanType::isPrimary).collect(Collectors.toList())).isEmpty()) {
            candidates = primary;
        }
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        if ((candidates = (List)candidates.stream().filter(candidate -> !candidate.hasDeclaredStereotype(Secondary.class)).collect(Collectors.toList())).size() == 1) {
            return (BeanDefinition)candidates.iterator().next();
        }
        if (candidates.stream().anyMatch(candidate -> candidate.hasAnnotation(Order.class))) {
            Iterator i = candidates.stream().sorted((bean1, bean2) -> {
                int order1 = OrderUtil.getOrder((AnnotationMetadata)bean1.getAnnotationMetadata());
                int order2 = OrderUtil.getOrder((AnnotationMetadata)bean2.getAnnotationMetadata());
                return Integer.compare(order1, order2);
            }).iterator();
            if (i.hasNext()) {
                BeanDefinition bean = (BeanDefinition)i.next();
                if (i.hasNext()) {
                    BeanDefinition next = (BeanDefinition)i.next();
                    if (OrderUtil.getOrder((AnnotationMetadata)bean.getAnnotationMetadata()) == OrderUtil.getOrder((AnnotationMetadata)next.getAnnotationMetadata())) {
                        throw new SerdeException("Multiple possible serializers found for type [" + type + "]: " + candidates);
                    }
                }
                return bean;
            }
            throw new SerdeException("Multiple possible serializers found for type [" + type + "]: " + candidates);
        }
        throw new SerdeException("Multiple possible serializers found for type [" + type + "]: " + candidates);
    }

    public Serializer.EncoderContext newEncoderContext(final Class<?> view) {
        if (view != null) {
            return new DefaultEncoderContext(this){

                public boolean hasView(Class<?> ... views) {
                    for (Class<?> candidate : views) {
                        if (!candidate.isAssignableFrom(view)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return new DefaultEncoderContext(this);
    }

    public Deserializer.DecoderContext newDecoderContext(final Class<?> view) {
        if (view != null) {
            return new DefaultDecoderContext(this){

                public boolean hasView(Class<?> ... views) {
                    for (Class<?> candidate : views) {
                        if (!candidate.isAssignableFrom(view)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return new DefaultDecoderContext(this);
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    private static abstract class SerdeRegistrar<T>
    implements Serde<T> {
        private SerdeRegistrar() {
        }

        @NonNull
        abstract Argument<T> getType();

        @NonNull
        Iterable<Argument<?>> getTypes() {
            return Collections.singleton(this.getType());
        }
    }

    private static final class IntegerSerde
    extends SerdeRegistrar<Integer>
    implements NumberSerde<Integer> {
        private IntegerSerde() {
        }

        public Integer deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Integer> type) throws IOException {
            return decoder.decodeInt();
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Integer> type, Integer value) throws IOException {
            encoder.encodeInt(value.intValue());
        }

        @Override
        Argument<Integer> getType() {
            return Argument.of(Integer.class);
        }

        @Override
        protected Iterable<Argument<?>> getTypes() {
            return Arrays.asList(this.getType(), Argument.INT);
        }

        @Nullable
        public Integer getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Integer> type) {
            return type.isPrimitive() ? Integer.valueOf(0) : null;
        }
    }

    private static final class LongSerde
    extends SerdeRegistrar<Long>
    implements NumberSerde<Long> {
        private LongSerde() {
        }

        public Long deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Long> type) throws IOException {
            return decoder.decodeLong();
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Long> type, Long value) throws IOException {
            encoder.encodeLong(value.longValue());
        }

        @Override
        Argument<Long> getType() {
            return Argument.of(Long.class);
        }

        @Override
        protected Iterable<Argument<?>> getTypes() {
            return Arrays.asList(this.getType(), Argument.LONG);
        }

        @Nullable
        public Long getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Long> type) {
            return type.isPrimitive() ? Long.valueOf(0L) : null;
        }
    }

    private static final class ShortSerde
    extends SerdeRegistrar<Short>
    implements NumberSerde<Short> {
        private ShortSerde() {
        }

        public Short deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Short> type) throws IOException {
            return decoder.decodeShort();
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Short> type, Short value) throws IOException {
            encoder.encodeShort(value.shortValue());
        }

        @Override
        Argument<Short> getType() {
            return Argument.of(Short.class);
        }

        @Override
        protected Iterable<Argument<?>> getTypes() {
            return Arrays.asList(this.getType(), Argument.SHORT);
        }

        @Nullable
        public Short getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Short> type) {
            return type.isPrimitive() ? Short.valueOf((short)0) : null;
        }
    }

    private static final class FloatSerde
    extends SerdeRegistrar<Float>
    implements NumberSerde<Float> {
        private FloatSerde() {
        }

        public Float deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Float> type) throws IOException {
            return Float.valueOf(decoder.decodeFloat());
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Float> type, Float value) throws IOException {
            encoder.encodeFloat(value.floatValue());
        }

        @Override
        Argument<Float> getType() {
            return Argument.of(Float.class);
        }

        @Override
        protected Iterable<Argument<?>> getTypes() {
            return Arrays.asList(this.getType(), Argument.FLOAT);
        }

        @Nullable
        public Float getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Float> type) {
            return type.isPrimitive() ? Float.valueOf(0.0f) : null;
        }
    }

    private static final class ByteSerde
    extends SerdeRegistrar<Byte>
    implements NumberSerde<Byte> {
        private ByteSerde() {
        }

        public Byte deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Byte> type) throws IOException {
            return decoder.decodeByte();
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Byte> type, Byte value) throws IOException {
            encoder.encodeByte(value.byteValue());
        }

        @Override
        Argument<Byte> getType() {
            return Argument.of(Byte.class);
        }

        @Override
        protected Iterable<Argument<?>> getTypes() {
            return Arrays.asList(this.getType(), Argument.BYTE);
        }

        @Nullable
        public Byte getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Byte> type) {
            return type.isPrimitive() ? Byte.valueOf((byte)0) : null;
        }
    }

    private static final class DoubleSerde
    extends SerdeRegistrar<Double>
    implements NumberSerde<Double> {
        private DoubleSerde() {
        }

        public Double deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Double> type) throws IOException {
            return decoder.decodeDouble();
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Double> type, Double value) throws IOException {
            encoder.encodeDouble(value.doubleValue());
        }

        @Override
        Argument<Double> getType() {
            return Argument.of(Double.class);
        }

        @Override
        protected Iterable<Argument<?>> getTypes() {
            return Arrays.asList(this.getType(), Argument.DOUBLE);
        }

        @Nullable
        public Double getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Double> type) {
            return type.isPrimitive() ? Double.valueOf(0.0) : null;
        }
    }

    private static final class OptionalIntSerde
    extends SerdeRegistrar<OptionalInt>
    implements Serde<OptionalInt> {
        private OptionalIntSerde() {
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends OptionalInt> type, OptionalInt value) throws IOException {
            if (value.isPresent()) {
                encoder.encodeInt(value.getAsInt());
            } else {
                encoder.encodeNull();
            }
        }

        public OptionalInt deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super OptionalInt> type) throws IOException {
            if (decoder.decodeNull()) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(decoder.decodeInt());
        }

        public OptionalInt getDefaultValue(Deserializer.DecoderContext context, Argument<? super OptionalInt> type) {
            return OptionalInt.empty();
        }

        public boolean isEmpty(Serializer.EncoderContext context, OptionalInt value) {
            return value == null || !value.isPresent();
        }

        public boolean isAbsent(Serializer.EncoderContext context, OptionalInt value) {
            return value == null || !value.isPresent();
        }

        @Override
        Argument<OptionalInt> getType() {
            return Argument.of(OptionalInt.class);
        }
    }

    private static final class OptionalDoubleSerde
    extends SerdeRegistrar<OptionalDouble>
    implements Serde<OptionalDouble> {
        private OptionalDoubleSerde() {
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends OptionalDouble> type, OptionalDouble value) throws IOException {
            if (value.isPresent()) {
                encoder.encodeDouble(value.getAsDouble());
            } else {
                encoder.encodeNull();
            }
        }

        public OptionalDouble deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super OptionalDouble> type) throws IOException {
            if (decoder.decodeNull()) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(decoder.decodeDouble());
        }

        public boolean isEmpty(Serializer.EncoderContext context, OptionalDouble value) {
            return value == null || !value.isPresent();
        }

        public boolean isAbsent(Serializer.EncoderContext context, OptionalDouble value) {
            return value == null || !value.isPresent();
        }

        public OptionalDouble getDefaultValue(Deserializer.DecoderContext context, Argument<? super OptionalDouble> type) {
            return OptionalDouble.empty();
        }

        @Override
        Argument<OptionalDouble> getType() {
            return Argument.of(OptionalDouble.class);
        }
    }

    private static final class OptionalLongSerde
    extends SerdeRegistrar<OptionalLong>
    implements Serde<OptionalLong> {
        private OptionalLongSerde() {
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends OptionalLong> type, OptionalLong value) throws IOException {
            if (value.isPresent()) {
                encoder.encodeLong(value.getAsLong());
            } else {
                encoder.encodeNull();
            }
        }

        public OptionalLong deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super OptionalLong> type) throws IOException {
            if (decoder.decodeNull()) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(decoder.decodeLong());
        }

        public OptionalLong getDefaultValue(Deserializer.DecoderContext context, Argument<? super OptionalLong> type) {
            return OptionalLong.empty();
        }

        public boolean isEmpty(Serializer.EncoderContext context, OptionalLong value) {
            return value == null || !value.isPresent();
        }

        public boolean isAbsent(Serializer.EncoderContext context, OptionalLong value) {
            return value == null || !value.isPresent();
        }

        @Override
        Argument<OptionalLong> getType() {
            return Argument.of(OptionalLong.class);
        }
    }

    private static final class BigDecimalSerde
    extends SerdeRegistrar<BigDecimal>
    implements NumberSerde<BigDecimal> {
        private BigDecimalSerde() {
        }

        @Override
        Argument<BigDecimal> getType() {
            return Argument.of(BigDecimal.class);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends BigDecimal> type, BigDecimal value) throws IOException {
            encoder.encodeBigDecimal(value);
        }

        public BigDecimal deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super BigDecimal> type) throws IOException {
            return decoder.decodeBigDecimal();
        }
    }

    private static final class BigIntegerSerde
    extends SerdeRegistrar<BigInteger>
    implements NumberSerde<BigInteger> {
        private BigIntegerSerde() {
        }

        @Override
        Argument<BigInteger> getType() {
            return Argument.of(BigInteger.class);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends BigInteger> type, BigInteger value) throws IOException {
            encoder.encodeBigInteger(value);
        }

        public BigInteger deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super BigInteger> type) throws IOException {
            return decoder.decodeBigInteger();
        }
    }

    private static final class UUIDSerde
    extends SerdeRegistrar<UUID>
    implements NullableSerde<UUID> {
        private UUIDSerde() {
        }

        @Override
        Argument<UUID> getType() {
            return Argument.of(UUID.class);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends UUID> type, UUID value) throws IOException {
            encoder.encodeString(value.toString());
        }

        public UUID deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super UUID> type) throws IOException {
            return UUID.fromString(decoder.decodeString());
        }
    }

    private static final class URLSerde
    extends SerdeRegistrar<URL>
    implements NullableSerde<URL> {
        private URLSerde() {
        }

        @Override
        Argument<URL> getType() {
            return Argument.of(URL.class);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends URL> type, URL value) throws IOException {
            encoder.encodeString(value.toString());
        }

        public URL deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super URL> type) throws IOException {
            return new URL(decoder.decodeString());
        }
    }

    private static final class URISerde
    extends SerdeRegistrar<URI>
    implements NullableSerde<URI> {
        private URISerde() {
        }

        @Override
        Argument<URI> getType() {
            return Argument.of(URI.class);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends URI> type, URI value) throws IOException {
            encoder.encodeString(value.toString());
        }

        public URI deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super URI> type) throws IOException {
            return URI.create(decoder.decodeString());
        }
    }

    private static final class CharsetSerde
    extends SerdeRegistrar<Charset>
    implements NullableSerde<Charset> {
        private CharsetSerde() {
        }

        @Override
        Argument<Charset> getType() {
            return Argument.of(Charset.class);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Charset> type, Charset value) throws IOException {
            encoder.encodeString(value.name());
        }

        public Charset deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Charset> type) throws IOException {
            return Charset.forName(decoder.decodeString());
        }
    }

    private static final class TimeZoneSerde
    extends SerdeRegistrar<TimeZone>
    implements NullableSerde<TimeZone> {
        private TimeZoneSerde() {
        }

        @Override
        Argument<TimeZone> getType() {
            return Argument.of(TimeZone.class);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends TimeZone> type, TimeZone value) throws IOException {
            encoder.encodeString(value.getID());
        }

        public TimeZone deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super TimeZone> type) throws IOException {
            return TimeZone.getTimeZone(decoder.decodeString());
        }
    }

    private static final class LocaleSerde
    extends SerdeRegistrar<Locale>
    implements NullableSerde<Locale> {
        private LocaleSerde() {
        }

        @Override
        Argument<Locale> getType() {
            return Argument.of(Locale.class);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Locale> type, Locale value) throws IOException {
            encoder.encodeString(value.toLanguageTag());
        }

        public Locale deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Locale> type) throws IOException {
            return StringUtils.parseLocale((String)decoder.decodeString());
        }
    }

    private static final class IntArraySerde
    extends SerdeRegistrar<int[]>
    implements NullableSerde<int[]> {
        private IntArraySerde() {
        }

        public int[] deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super int[]> type) throws IOException {
            Decoder arrayDecoder = decoder.decodeArray();
            int[] buffer = new int[50];
            int index = 0;
            while (arrayDecoder.hasNextArrayValue()) {
                if (buffer.length == index) {
                    buffer = Arrays.copyOf(buffer, buffer.length * 2);
                }
                if (!arrayDecoder.decodeNull()) {
                    buffer[index] = arrayDecoder.decodeInt();
                }
                ++index;
            }
            arrayDecoder.finishStructure();
            return Arrays.copyOf(buffer, index);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends int[]> type, int[] value) throws IOException {
            Encoder arrayEncoder = encoder.encodeArray(type);
            for (int i : value) {
                arrayEncoder.encodeInt(i);
            }
            arrayEncoder.finishStructure();
        }

        public boolean isEmpty(Serializer.EncoderContext context, int[] value) {
            return value == null || value.length == 0;
        }

        @Override
        Argument<int[]> getType() {
            return Argument.of(int[].class);
        }
    }

    private static final class LongArraySerde
    extends SerdeRegistrar<long[]>
    implements NullableSerde<long[]> {
        private LongArraySerde() {
        }

        public long[] deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super long[]> type) throws IOException {
            Decoder arrayDecoder = decoder.decodeArray();
            long[] buffer = new long[50];
            int index = 0;
            while (arrayDecoder.hasNextArrayValue()) {
                if (buffer.length == index) {
                    buffer = Arrays.copyOf(buffer, buffer.length * 2);
                }
                if (!arrayDecoder.decodeNull()) {
                    buffer[index] = arrayDecoder.decodeLong();
                }
                ++index;
            }
            arrayDecoder.finishStructure();
            return Arrays.copyOf(buffer, index);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends long[]> type, long[] value) throws IOException {
            Encoder arrayEncoder = encoder.encodeArray(type);
            for (long i : value) {
                arrayEncoder.encodeLong(i);
            }
            arrayEncoder.finishStructure();
        }

        public boolean isEmpty(Serializer.EncoderContext context, long[] value) {
            return value == null || value.length == 0;
        }

        @Override
        Argument<long[]> getType() {
            return Argument.of(long[].class);
        }
    }

    private static final class FloatArraySerde
    extends SerdeRegistrar<float[]>
    implements NullableSerde<float[]> {
        private FloatArraySerde() {
        }

        public float[] deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super float[]> type) throws IOException {
            Decoder arrayDecoder = decoder.decodeArray();
            float[] buffer = new float[50];
            int index = 0;
            while (arrayDecoder.hasNextArrayValue()) {
                if (buffer.length == index) {
                    buffer = Arrays.copyOf(buffer, buffer.length * 2);
                }
                if (!arrayDecoder.decodeNull()) {
                    buffer[index] = arrayDecoder.decodeFloat();
                }
                ++index;
            }
            arrayDecoder.finishStructure();
            return Arrays.copyOf(buffer, index);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends float[]> type, float[] value) throws IOException {
            Encoder arrayEncoder = encoder.encodeArray(type);
            for (float i : value) {
                arrayEncoder.encodeFloat(i);
            }
            arrayEncoder.finishStructure();
        }

        public boolean isEmpty(Serializer.EncoderContext context, float[] value) {
            return value == null || value.length == 0;
        }

        @Override
        Argument<float[]> getType() {
            return Argument.of(float[].class);
        }
    }

    private static final class ShortArraySerde
    extends SerdeRegistrar<short[]>
    implements NullableSerde<short[]> {
        private ShortArraySerde() {
        }

        public short[] deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super short[]> type) throws IOException {
            Decoder arrayDecoder = decoder.decodeArray();
            short[] buffer = new short[50];
            int index = 0;
            while (arrayDecoder.hasNextArrayValue()) {
                if (buffer.length == index) {
                    buffer = Arrays.copyOf(buffer, buffer.length * 2);
                }
                if (!arrayDecoder.decodeNull()) {
                    buffer[index] = arrayDecoder.decodeShort();
                }
                ++index;
            }
            arrayDecoder.finishStructure();
            return Arrays.copyOf(buffer, index);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends short[]> type, short[] value) throws IOException {
            Encoder arrayEncoder = encoder.encodeArray(type);
            for (short i : value) {
                arrayEncoder.encodeShort(i);
            }
            arrayEncoder.finishStructure();
        }

        public boolean isEmpty(Serializer.EncoderContext context, short[] value) {
            return value == null || value.length == 0;
        }

        @Override
        Argument<short[]> getType() {
            return Argument.of(short[].class);
        }
    }

    private static final class DoubleArraySerde
    extends SerdeRegistrar<double[]>
    implements NullableSerde<double[]> {
        private DoubleArraySerde() {
        }

        public double[] deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super double[]> type) throws IOException {
            Decoder arrayDecoder = decoder.decodeArray();
            double[] buffer = new double[50];
            int index = 0;
            while (arrayDecoder.hasNextArrayValue()) {
                if (buffer.length == index) {
                    buffer = Arrays.copyOf(buffer, buffer.length * 2);
                }
                if (!arrayDecoder.decodeNull()) {
                    buffer[index] = arrayDecoder.decodeDouble();
                }
                ++index;
            }
            arrayDecoder.finishStructure();
            return Arrays.copyOf(buffer, index);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends double[]> type, double[] value) throws IOException {
            Encoder arrayEncoder = encoder.encodeArray(type);
            for (double i : value) {
                arrayEncoder.encodeDouble(i);
            }
            arrayEncoder.finishStructure();
        }

        public boolean isEmpty(Serializer.EncoderContext context, double[] value) {
            return value == null || value.length == 0;
        }

        @Override
        Argument<double[]> getType() {
            return Argument.of(double[].class);
        }
    }

    private static final class BooleanArraySerde
    extends SerdeRegistrar<boolean[]>
    implements NullableSerde<boolean[]> {
        private BooleanArraySerde() {
        }

        public boolean[] deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super boolean[]> type) throws IOException {
            Decoder arrayDecoder = decoder.decodeArray();
            boolean[] buffer = new boolean[50];
            int index = 0;
            while (arrayDecoder.hasNextArrayValue()) {
                if (buffer.length == index) {
                    buffer = Arrays.copyOf(buffer, buffer.length * 2);
                }
                if (!arrayDecoder.decodeNull()) {
                    buffer[index] = arrayDecoder.decodeBoolean();
                }
                ++index;
            }
            arrayDecoder.finishStructure();
            return Arrays.copyOf(buffer, index);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends boolean[]> type, boolean[] value) throws IOException {
            Encoder arrayEncoder = encoder.encodeArray(type);
            for (boolean i : value) {
                arrayEncoder.encodeBoolean(i);
            }
            arrayEncoder.finishStructure();
        }

        public boolean isEmpty(Serializer.EncoderContext context, boolean[] value) {
            return value == null || value.length == 0;
        }

        @Override
        Argument<boolean[]> getType() {
            return Argument.of(boolean[].class);
        }
    }

    private static final class ByteArraySerde
    extends SerdeRegistrar<byte[]>
    implements NullableSerde<byte[]> {
        private ByteArraySerde() {
        }

        public byte[] deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super byte[]> type) throws IOException {
            Decoder arrayDecoder = decoder.decodeArray();
            byte[] buffer = new byte[100];
            int index = 0;
            while (arrayDecoder.hasNextArrayValue()) {
                if (buffer.length == index) {
                    buffer = Arrays.copyOf(buffer, buffer.length * 2);
                }
                if (!arrayDecoder.decodeNull()) {
                    buffer[index] = arrayDecoder.decodeByte();
                }
                ++index;
            }
            arrayDecoder.finishStructure();
            return Arrays.copyOf(buffer, index);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends byte[]> type, byte[] value) throws IOException {
            Encoder arrayEncoder = encoder.encodeArray(type);
            for (byte i : value) {
                arrayEncoder.encodeByte(i);
            }
            arrayEncoder.finishStructure();
        }

        public boolean isEmpty(Serializer.EncoderContext context, byte[] value) {
            return value == null || value.length == 0;
        }

        @Override
        Argument<byte[]> getType() {
            return Argument.of(byte[].class);
        }
    }

    private static final class CharArraySerde
    extends SerdeRegistrar<char[]>
    implements NullableSerde<char[]> {
        private CharArraySerde() {
        }

        public char[] deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super char[]> type) throws IOException {
            Decoder arrayDecoder = decoder.decodeArray();
            char[] buffer = new char[100];
            int index = 0;
            while (arrayDecoder.hasNextArrayValue()) {
                if (buffer.length == index) {
                    buffer = Arrays.copyOf(buffer, buffer.length * 2);
                }
                if (!arrayDecoder.decodeNull()) {
                    buffer[index] = arrayDecoder.decodeChar();
                }
                ++index;
            }
            arrayDecoder.finishStructure();
            return Arrays.copyOf(buffer, index);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends char[]> type, char[] value) throws IOException {
            Encoder arrayEncoder = encoder.encodeArray(type);
            for (char i : value) {
                arrayEncoder.encodeChar(i);
            }
            arrayEncoder.finishStructure();
        }

        public boolean isEmpty(Serializer.EncoderContext context, char[] value) {
            return value == null || value.length == 0;
        }

        @Override
        Argument<char[]> getType() {
            return Argument.of(char[].class);
        }
    }

    private static final class StringSerde
    extends SerdeRegistrar<String>
    implements NullableSerde<String> {
        private StringSerde() {
        }

        @Override
        Argument<String> getType() {
            return Argument.of(String.class);
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends String> type, String value) throws IOException {
            encoder.encodeString(value);
        }

        public String deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super String> type) throws IOException {
            return decoder.decodeString();
        }
    }

    private static final class BooleanSerde
    extends SerdeRegistrar<Boolean>
    implements NullableSerde<Boolean> {
        private BooleanSerde() {
        }

        public Boolean deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Boolean> type) throws IOException {
            return decoder.decodeBoolean();
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Boolean> type, Boolean value) throws IOException {
            encoder.encodeBoolean(value.booleanValue());
        }

        @Override
        Argument<Boolean> getType() {
            return Argument.of(Boolean.class);
        }

        @Override
        protected Iterable<Argument<?>> getTypes() {
            return Arrays.asList(this.getType(), Argument.BOOLEAN);
        }

        @Nullable
        public Boolean getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Boolean> type) {
            return type.isPrimitive() ? Boolean.valueOf(false) : null;
        }
    }

    private static final class CharSerde
    extends SerdeRegistrar<Character>
    implements NullableSerde<Character> {
        private CharSerde() {
        }

        public Character deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Character> type) throws IOException {
            return Character.valueOf(decoder.decodeChar());
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Character> type, Character value) throws IOException {
            encoder.encodeChar(value.charValue());
        }

        @Override
        Argument<Character> getType() {
            return Argument.of(Character.class);
        }

        @Override
        protected Iterable<Argument<?>> getTypes() {
            return Arrays.asList(this.getType(), Argument.CHAR);
        }

        @Nullable
        public Character getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Character> type) {
            return type.isPrimitive() ? Character.valueOf('\u0000') : null;
        }
    }
}

