/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanMethod;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.UnsafeBeanProperty;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.GenericPlaceholder;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserBeanRegistry;
import io.micronaut.serde.support.deserializers.PropertiesBag;
import io.micronaut.serde.support.deserializers.SubtypedDeserBean;
import io.micronaut.serde.support.util.SerdeAnnotationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

@Internal
class DeserBean<T> {
    private static final String JK_PROP = "com.fasterxml.jackson.annotation.JsonProperty";
    @NonNull
    public final BeanIntrospection<T> introspection;
    @Nullable
    public final PropertiesBag<T> creatorParams;
    @Nullable
    public final DerProperty<T, ?>[] creatorUnwrapped;
    @Nullable
    public final PropertiesBag<T> readProperties;
    @Nullable
    public final DerProperty<T, Object>[] unwrappedProperties;
    @Nullable
    public final AnySetter<Object> anySetter;
    public final int creatorSize;
    public final boolean ignoreUnknown;
    public final boolean delegating;
    public final boolean simpleBean;
    public final ConversionService conversionService;
    private volatile boolean initialized;

    public DeserBean(BeanIntrospection<T> introspection, Deserializer.DecoderContext decoderContext, DeserBeanRegistry deserBeanRegistry) throws SerdeException {
        this.conversionService = decoderContext.getConversionService();
        this.introspection = introspection;
        SerdeConfig.SerCreatorMode creatorMode = introspection.getConstructor().getAnnotationMetadata().enumValue(Creator.class, "mode", SerdeConfig.SerCreatorMode.class).orElse(null);
        this.delegating = creatorMode == SerdeConfig.SerCreatorMode.DELEGATING;
        Argument[] constructorArguments = introspection.getConstructorArguments();
        this.creatorSize = constructorArguments.length;
        PropertyNamingStrategy entityPropertyNamingStrategy = this.getPropertyNamingStrategy((AnnotationMetadata)introspection, decoderContext, null);
        this.ignoreUnknown = introspection.booleanValue(SerdeConfig.SerIgnored.class, "ignoreUnknown").orElse(true);
        PropertiesBag<T> creatorParams = new PropertiesBag<T>(introspection, constructorArguments.length);
        ArrayList creatorUnwrapped = null;
        AnySetter anySetterValue = null;
        ArrayList unwrappedProperties = null;
        for (int i = 0; i < constructorArguments.length; ++i) {
            DerProperty<T, Object> derProperty;
            Argument constructorArgument = this.resolveArgument(constructorArguments[i]);
            AnnotationMetadata annotationMetadata = DeserBean.resolveArgumentMetadata(introspection, constructorArgument, constructorArgument.getAnnotationMetadata());
            if (annotationMetadata.isTrue(SerdeConfig.class, "ignored")) continue;
            if (annotationMetadata.isAnnotationPresent(SerdeConfig.SerAnySetter.class)) {
                anySetterValue = new AnySetter(constructorArgument, i);
                String n = constructorArgument.getName();
                creatorParams.register(n, new DerProperty(this.conversionService, introspection, i, n, constructorArgument, null, null, null), false);
                continue;
            }
            PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(annotationMetadata, decoderContext, entityPropertyNamingStrategy);
            String jsonProperty = this.resolveName((AnnotatedElement)constructorArgument, annotationMetadata, propertyNamingStrategy);
            Argument constructorWithPropertyArgument = Argument.of((Class)constructorArgument.getType(), (String)constructorArgument.getName(), (AnnotationMetadata)annotationMetadata, (Argument[])constructorArgument.getTypeParameters());
            boolean isUnwrapped = annotationMetadata.hasAnnotation(SerdeConfig.SerUnwrapped.class);
            if (isUnwrapped) {
                if (creatorUnwrapped == null) {
                    creatorUnwrapped = new ArrayList();
                }
                DeserBean unwrapped = deserBeanRegistry.getDeserializableBean(constructorArgument, decoderContext);
                creatorUnwrapped.add(new DerProperty(this.conversionService, introspection, i, jsonProperty, constructorWithPropertyArgument, null, null, unwrapped));
                String prefix = annotationMetadata.stringValue(SerdeConfig.SerUnwrapped.class, "prefix").orElse("");
                String suffix = annotationMetadata.stringValue(SerdeConfig.SerUnwrapped.class, "suffix").orElse("");
                PropertiesBag<T> unwrappedCreatorParams = unwrapped.creatorParams;
                if (unwrappedCreatorParams != null) {
                    for (Map.Entry<String, DerProperty<T, Object>> e : unwrappedCreatorParams.getProperties()) {
                        String resolved = prefix + e.getKey() + suffix;
                        creatorParams.register(resolved, e.getValue(), false);
                    }
                }
                derProperty = new DerProperty(this.conversionService, introspection, i, jsonProperty, constructorWithPropertyArgument, null, null, unwrapped);
            } else {
                derProperty = new DerProperty(this.conversionService, introspection, i, jsonProperty, constructorWithPropertyArgument, null, null, null);
            }
            creatorParams.register(jsonProperty, derProperty, true);
        }
        List beanProperties = introspection.getBeanProperties().stream().filter(bp -> {
            AnnotationMetadata annotationMetadata = bp.getAnnotationMetadata();
            return !bp.isReadOnly() && annotationMetadata.booleanValue(SerdeConfig.class, "writeOnly").orElse(false) == false && annotationMetadata.booleanValue(SerdeConfig.class, "ignored").orElse(false) == false;
        }).collect(Collectors.toList());
        Collection beanMethods = introspection.getBeanMethods();
        ArrayList<BeanMethod> jsonSetters = new ArrayList<BeanMethod>(beanMethods.size());
        BeanMethod anySetter = null;
        for (BeanMethod method : beanMethods) {
            if (method.isAnnotationPresent(SerdeConfig.SerSetter.class)) {
                jsonSetters.add(method);
                continue;
            }
            if (!method.isAnnotationPresent(SerdeConfig.SerAnySetter.class) || !ArrayUtils.isNotEmpty((Object[])method.getArguments())) continue;
            anySetter = method;
        }
        if (anySetterValue == null) {
            AnySetter anySetter2 = anySetterValue = anySetter != null ? new AnySetter(anySetter) : null;
        }
        if (CollectionUtils.isNotEmpty(beanProperties) || CollectionUtils.isNotEmpty(jsonSetters)) {
            this.readProperties = new PropertiesBag<T>(introspection);
            for (int i = 0; i < beanProperties.size(); ++i) {
                BeanProperty beanProperty = (BeanProperty)beanProperties.get(i);
                PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(beanProperty.getAnnotationMetadata(), decoderContext, entityPropertyNamingStrategy);
                AnnotationMetadata annotationMetadata = beanProperty.getAnnotationMetadata();
                if (annotationMetadata.isAnnotationPresent(SerdeConfig.SerAnySetter.class)) {
                    anySetterValue = new AnySetter((BeanProperty<? super Object, Object>)beanProperty);
                    continue;
                }
                boolean isUnwrapped = annotationMetadata.hasAnnotation(SerdeConfig.SerUnwrapped.class);
                Argument t = this.resolveArgument(beanProperty.asArgument());
                if (isUnwrapped) {
                    PropertiesBag<T> unwrappedCreatorParams;
                    if (unwrappedProperties == null) {
                        unwrappedProperties = new ArrayList();
                    }
                    DeserBean unwrapped = deserBeanRegistry.getDeserializableBean(t, decoderContext);
                    AnnotationMetadataHierarchy combinedMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{annotationMetadata, t.getAnnotationMetadata()});
                    unwrappedProperties.add(new DerProperty(this.conversionService, introspection, i, t.getName(), t, (AnnotationMetadata)combinedMetadata, beanProperty, null, unwrapped));
                    String prefix = annotationMetadata.stringValue(SerdeConfig.SerUnwrapped.class, "prefix").orElse("");
                    String suffix = annotationMetadata.stringValue(SerdeConfig.SerUnwrapped.class, "suffix").orElse("");
                    PropertiesBag<T> unwrappedProps = unwrapped.readProperties;
                    if (unwrappedProps != null) {
                        for (Map.Entry<String, DerProperty<T, Object>> e : unwrappedProps.getProperties()) {
                            String resolved = prefix + e.getKey() + suffix;
                            this.readProperties.register(resolved, e.getValue(), false);
                        }
                    }
                    if ((unwrappedCreatorParams = unwrapped.creatorParams) == null) continue;
                    for (Map.Entry<String, DerProperty<T, Object>> e : unwrappedCreatorParams.getProperties()) {
                        String resolved = prefix + e.getKey() + suffix;
                        creatorParams.register(resolved, e.getValue(), false);
                    }
                    continue;
                }
                String jsonProperty = this.resolveName((AnnotatedElement)beanProperty, annotationMetadata, propertyNamingStrategy);
                DerProperty derProperty = new DerProperty(this.conversionService, introspection, i, jsonProperty, t, beanProperty, null, null);
                this.readProperties.register(jsonProperty, derProperty, true);
            }
            for (final BeanMethod jsonSetter : jsonSetters) {
                PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(jsonSetter.getAnnotationMetadata(), decoderContext, entityPropertyNamingStrategy);
                String property = this.resolveName(new AnnotatedElement(){

                    public String getName() {
                        return NameUtils.getPropertyNameForSetter((String)jsonSetter.getName());
                    }

                    public AnnotationMetadata getAnnotationMetadata() {
                        return jsonSetter.getAnnotationMetadata();
                    }
                }, jsonSetter.getAnnotationMetadata(), propertyNamingStrategy);
                Argument argument = this.resolveArgument(jsonSetter.getArguments()[0]);
                DerProperty derProperty = new DerProperty(this.conversionService, introspection, 0, property, argument, null, jsonSetter, null);
                this.readProperties.register(property, derProperty, true);
            }
        } else {
            this.readProperties = null;
        }
        this.anySetter = anySetterValue;
        this.creatorParams = creatorParams.getProperties().isEmpty() ? null : creatorParams;
        this.creatorUnwrapped = creatorUnwrapped != null ? creatorUnwrapped.toArray(new DerProperty[0]) : null;
        DerProperty[] derPropertyArray = this.unwrappedProperties = unwrappedProperties != null ? unwrappedProperties.toArray(new DerProperty[0]) : null;
        if (this.creatorParams != null) {
            this.creatorParams.seal();
        }
        if (this.readProperties != null) {
            this.readProperties.seal();
        }
        this.simpleBean = this.isSimpleBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Deserializer.DecoderContext decoderContext) throws SerdeException {
        if (!this.initialized) {
            DeserBean deserBean = this;
            synchronized (deserBean) {
                if (!this.initialized) {
                    DerProperty<T, Object> property;
                    List<Map.Entry<String, DerProperty<T, Object>>> properties;
                    if (this.readProperties != null) {
                        properties = this.readProperties.getProperties();
                        for (Map.Entry<String, DerProperty<T, Object>> e : properties) {
                            property = e.getValue();
                            this.initProperty(property, decoderContext);
                        }
                    }
                    if (this.creatorParams != null) {
                        properties = this.creatorParams.getProperties();
                        for (Map.Entry<String, DerProperty<T, Object>> e : properties) {
                            property = e.getValue();
                            this.initProperty(property, decoderContext);
                        }
                    }
                    if (this.anySetter != null) {
                        Object object = this.anySetter.deserializer = this.anySetter.valueType.equalsType(Argument.OBJECT_ARGUMENT) ? null : DeserBean.findDeserializer(decoderContext, this.anySetter.valueType);
                    }
                    if (this.unwrappedProperties != null) {
                        for (DerProperty<T, Object> unwrappedProperty : this.unwrappedProperties) {
                            this.initProperty(unwrappedProperty, decoderContext);
                        }
                    }
                    this.initialized = true;
                }
            }
        }
    }

    private boolean isSimpleBean() {
        if (this.delegating || this instanceof SubtypedDeserBean || this.creatorParams != null || this.creatorUnwrapped != null || this.unwrappedProperties != null || this.anySetter != null) {
            return false;
        }
        if (this.readProperties != null) {
            for (Map.Entry<String, DerProperty<T, Object>> e : this.readProperties.getProperties()) {
                DerProperty<T, Object> property = e.getValue();
                if (!property.isAnySetter && property.views == null && property.managedRef == null && this.introspection == property.instrospection && property.backRef == null) continue;
                return false;
            }
        }
        return true;
    }

    private void initProperty(DerProperty<T, Object> property, Deserializer.DecoderContext decoderContext) throws SerdeException {
        property.deserializer = DeserBean.findDeserializer(decoderContext, property.argument);
        if (property.unwrapped != null) {
            property.unwrapped.initialize(decoderContext);
        }
    }

    private PropertyNamingStrategy getPropertyNamingStrategy(AnnotationMetadata annotationMetadata, Deserializer.DecoderContext decoderContext, PropertyNamingStrategy defaultNamingStrategy) throws SerdeException {
        Class namingStrategyClass = annotationMetadata.classValue(SerdeConfig.class, "runtimeNaming").orElse(null);
        return namingStrategyClass == null ? defaultNamingStrategy : decoderContext.findNamingStrategy(namingStrategyClass);
    }

    private <A> Argument<A> resolveArgument(Argument<A> argument) {
        Map<String, Argument<?>> bounds;
        if ((argument instanceof GenericPlaceholder || argument.hasTypeVariables()) && !(bounds = this.getBounds()).isEmpty()) {
            return this.resolveArgument(argument, bounds);
        }
        return argument;
    }

    private <A> Argument<A> resolveArgument(Argument<A> argument, Map<String, Argument<?>> bounds) {
        Argument[] declaredParameters = argument.getTypeParameters();
        Argument<?>[] typeParameters = this.resolveParameters(bounds, declaredParameters);
        if (argument instanceof GenericPlaceholder) {
            GenericPlaceholder gp = (GenericPlaceholder)argument;
            Argument<?> resolved = bounds.get(gp.getVariableName());
            if (resolved != null) {
                return Argument.of((Class)resolved.getType(), (String)argument.getName(), (AnnotationMetadata)argument.getAnnotationMetadata(), typeParameters);
            }
            if (typeParameters != declaredParameters) {
                return Argument.ofTypeVariable((Class)argument.getType(), (String)argument.getName(), (String)gp.getVariableName(), (AnnotationMetadata)gp.getAnnotationMetadata(), typeParameters);
            }
        } else if (typeParameters != declaredParameters) {
            return Argument.of((Class)argument.getType(), (String)argument.getName(), (AnnotationMetadata)argument.getAnnotationMetadata(), typeParameters);
        }
        return argument;
    }

    private Argument<?>[] resolveParameters(Map<String, Argument<?>> bounds, Argument[] typeParameters) {
        if (ArrayUtils.isEmpty((Object[])typeParameters)) {
            return typeParameters;
        }
        Argument[] resolvedParameters = new Argument[typeParameters.length];
        boolean differ = false;
        for (int i = 0; i < typeParameters.length; ++i) {
            Argument typeParameter = typeParameters[i];
            Argument resolved = this.resolveArgument(typeParameter, bounds);
            if (resolved != typeParameter) {
                resolvedParameters[i] = resolved;
                differ = true;
                continue;
            }
            resolvedParameters[i] = typeParameter;
        }
        return differ ? resolvedParameters : typeParameters;
    }

    @NonNull
    protected Map<String, Argument<?>> getBounds() {
        return Collections.emptyMap();
    }

    private String resolveName(AnnotatedElement annotatedElement, AnnotationMetadata annotationMetadata, PropertyNamingStrategy namingStrategy) {
        if (namingStrategy != null) {
            return namingStrategy.translate(annotatedElement);
        }
        return annotationMetadata.stringValue(SerdeConfig.class, "property").orElseGet(() -> annotationMetadata.stringValue(JK_PROP).orElseGet(() -> ((AnnotatedElement)annotatedElement).getName()));
    }

    private static <T> Deserializer<T> findDeserializer(Deserializer.DecoderContext decoderContext, Argument<T> argument) throws SerdeException {
        Class customDeser = argument.getAnnotationMetadata().classValue(SerdeConfig.class, "deserializerClass").orElse(null);
        if (customDeser != null) {
            return decoderContext.findCustomDeserializer(customDeser).createSpecific(decoderContext, argument);
        }
        return decoderContext.findDeserializer(argument).createSpecific(decoderContext, argument);
    }

    private static <B, P> AnnotationMetadata resolveArgumentMetadata(BeanIntrospection<B> instrospection, Argument<P> argument, AnnotationMetadata annotationMetadata) {
        AnnotationMetadata propertyMetadata = instrospection.getProperty(argument.getName(), argument.getType()).map(AnnotationMetadataProvider::getAnnotationMetadata).orElse(AnnotationMetadata.EMPTY_METADATA);
        return new AnnotationMetadataHierarchy(new AnnotationMetadata[]{propertyMetadata, annotationMetadata});
    }

    static final class AnySetter<T> {
        final Argument<T> valueType;
        private final BiConsumer<Object, Map<String, ? extends T>> mapSetter;
        private final TriConsumer<Object, T> valueSetter;
        public Deserializer<? extends T> deserializer;

        private AnySetter(BeanMethod<? super Object, Object> anySetter) {
            Argument argument;
            Argument[] arguments = anySetter.getArguments();
            boolean singleArg = arguments.length == 1;
            this.valueType = argument = singleArg ? arguments[0].getTypeVariable("V").orElse(Argument.OBJECT_ARGUMENT) : arguments[1];
            if (singleArg) {
                this.valueSetter = null;
                this.mapSetter = (x$0, xva$1) -> anySetter.invoke(x$0, new Object[]{xva$1});
            } else {
                this.valueSetter = (x$0, xva$1, xva$2) -> anySetter.invoke(x$0, new Object[]{xva$1, xva$2});
                this.mapSetter = null;
            }
        }

        private AnySetter(BeanProperty<? super Object, Object> anySetter) {
            Argument argument;
            this.valueType = argument = anySetter.asArgument().getTypeVariable("V").orElse(Argument.OBJECT_ARGUMENT);
            this.mapSetter = (arg_0, arg_1) -> anySetter.set(arg_0, arg_1);
            this.valueSetter = null;
        }

        private AnySetter(Argument<Object> anySetter, int index) throws SerdeException {
            Argument argument;
            this.valueType = argument = anySetter.getTypeVariable("V").orElse(Argument.OBJECT_ARGUMENT);
            this.mapSetter = (o, map) -> {
                ((Object[])o)[index] = map;
            };
            this.valueSetter = null;
        }

        void bind(Map<String, T> values, Object object) {
            if (values != null) {
                if (this.mapSetter != null) {
                    this.mapSetter.accept(object, values);
                } else if (this.valueSetter != null) {
                    for (String s : values.keySet()) {
                        this.valueSetter.accept(object, s, values.get(s));
                    }
                }
            }
        }
    }

    @Internal
    public static final class DerProperty<B, P> {
        public final BeanIntrospection<B> instrospection;
        public final int index;
        public final Argument<P> argument;
        @Nullable
        public final P defaultValue;
        public final boolean mustSetField;
        public final boolean explicitlyRequired;
        public final boolean nonNull;
        public final boolean nullable;
        public final boolean isAnySetter;
        @Nullable
        public final Class<?>[] views;
        @Nullable
        public final String[] aliases;
        @Nullable
        public final UnsafeBeanProperty<B, P> beanProperty;
        @Nullable
        public final BeanMethod<B, P> beanMethod;
        public final DeserBean<P> unwrapped;
        public final String managedRef;
        public final String backRef;
        public Deserializer<? super P> deserializer;

        public DerProperty(ConversionService conversionService, BeanIntrospection<B> introspection, int index, String property, Argument<P> argument, @Nullable BeanProperty<B, P> beanProperty, @Nullable BeanMethod<B, P> beanMethod, @Nullable DeserBean<P> unwrapped) throws SerdeException {
            this(conversionService, introspection, index, property, argument, argument.getAnnotationMetadata(), beanProperty, beanMethod, unwrapped);
        }

        public DerProperty(ConversionService conversionService, BeanIntrospection<B> instrospection, int index, String property, Argument<P> argument, AnnotationMetadata argumentMetadata, @Nullable BeanProperty<B, P> beanProperty, @Nullable BeanMethod<B, P> beanMethod, @Nullable DeserBean<P> unwrapped) throws SerdeException {
            this.instrospection = instrospection;
            this.index = index;
            this.argument = argument;
            this.mustSetField = argument.isNonNull() || argument.isAssignableFrom(Optional.class) || argument.isAssignableFrom(OptionalLong.class) || argument.isAssignableFrom(OptionalDouble.class) || argument.isAssignableFrom(OptionalInt.class);
            this.nonNull = argument.isNonNull();
            this.nullable = argument.isNullable();
            this.beanProperty = (UnsafeBeanProperty)beanProperty;
            this.beanMethod = beanMethod;
            AnnotationMetadata annotationMetadata = DeserBean.resolveArgumentMetadata(instrospection, argument, argumentMetadata);
            this.views = SerdeAnnotationUtil.resolveViews(instrospection, annotationMetadata);
            try {
                this.defaultValue = annotationMetadata.stringValue(Bindable.class, "defaultValue").map(s -> conversionService.convertRequired(s, argument)).orElse(null);
            }
            catch (ConversionErrorException e) {
                throw new SerdeException((index > -1 ? "Constructor Argument" : "Property") + " [" + argument + "] of type [" + instrospection.getBeanType().getName() + "] defines an invalid default value", (Throwable)e);
            }
            this.unwrapped = unwrapped;
            this.isAnySetter = annotationMetadata.isAnnotationPresent(SerdeConfig.SerAnySetter.class);
            Object[] aliases = annotationMetadata.stringValues(SerdeConfig.class, "aliases");
            this.aliases = ArrayUtils.isNotEmpty((Object[])aliases) ? (String[])ArrayUtils.concat((Object[])aliases, (Object[])new String[]{property}) : null;
            this.managedRef = annotationMetadata.stringValue(SerdeConfig.SerManagedRef.class).orElse(null);
            this.backRef = annotationMetadata.stringValue(SerdeConfig.SerBackRef.class).orElse(null);
            this.explicitlyRequired = annotationMetadata.booleanValue(SerdeConfig.class, "required").orElse(false);
        }

        public void setDefault(Deserializer.DecoderContext decoderContext, @NonNull B bean) throws SerdeException {
            if (!this.explicitlyRequired) {
                Object def = this.defaultValue;
                if (def == null) {
                    if (!this.mustSetField) {
                        return;
                    }
                    def = this.deserializer.getDefaultValue(decoderContext, this.argument);
                }
                if (def != null) {
                    if (this.beanProperty != null) {
                        this.beanProperty.setUnsafe(bean, def);
                        return;
                    }
                    if (this.beanMethod != null) {
                        this.beanMethod.invoke(bean, new Object[]{def});
                        return;
                    }
                }
            }
            throw new SerdeException("Unable to deserialize type [" + this.instrospection.getBeanType().getName() + "]. Required property [" + this.argument + "] is not present in supplied data");
        }

        public void setDefault(Deserializer.DecoderContext decoderContext, @NonNull Object[] params) throws SerdeException {
            if (!this.explicitlyRequired) {
                if (this.defaultValue != null) {
                    params[this.index] = this.defaultValue;
                    return;
                }
                if (!this.mustSetField && !this.argument.isPrimitive()) {
                    return;
                }
                Object newDefaultValue = this.deserializer.getDefaultValue(decoderContext, this.argument);
                if (newDefaultValue != null) {
                    params[this.index] = newDefaultValue;
                    return;
                }
            }
            throw new SerdeException("Unable to deserialize type [" + this.instrospection.getBeanType().getName() + "]. Required constructor parameter [" + this.argument + "] at index [" + this.index + "] is not present or is null in the supplied data");
        }

        public void set(@NonNull B obj, @Nullable P v) throws SerdeException {
            if (v == null && this.nonNull) {
                throw new SerdeException("Unable to deserialize type [" + this.instrospection.getBeanType().getName() + "]. Required property [" + this.argument + "] is not present in supplied data");
            }
            if (this.beanProperty != null) {
                this.beanProperty.setUnsafe(obj, v);
            }
            if (this.beanMethod != null) {
                this.beanMethod.invoke(obj, new Object[]{v});
            }
        }
    }

    private static interface TriConsumer<T, V> {
        public void accept(T var1, String var2, V var3);
    }
}

