/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.serde.support.deserializers.DeserBean;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

final class PropertiesBag<T> {
    private final BeanIntrospection<T> beanIntrospection;
    private final int[] originalNameToPropertiesMapping;
    private List<DeserBean.DerProperty<T, Object>> properties;
    @Nullable
    private Map<String, Integer> nameToPropertiesMapping;

    public PropertiesBag(BeanIntrospection<T> beanIntrospection) {
        this(beanIntrospection, beanIntrospection.getBeanProperties().size());
    }

    public PropertiesBag(BeanIntrospection<T> beanIntrospection, int expectedPropertiesSize) {
        this.beanIntrospection = beanIntrospection;
        int beanPropertiesSize = beanIntrospection.getBeanProperties().size();
        this.originalNameToPropertiesMapping = new int[beanPropertiesSize];
        Arrays.fill(this.originalNameToPropertiesMapping, -1);
        this.properties = new ArrayList<DeserBean.DerProperty<T, Object>>(expectedPropertiesSize);
    }

    public void register(String name, DeserBean.DerProperty<T, Object> derProperty, boolean addAliases) {
        int newPropertyIndex = this.properties.size();
        if (derProperty.beanProperty != null && derProperty.beanProperty.getDeclaringBean() == this.beanIntrospection && name.equals(derProperty.beanProperty.getName())) {
            this.originalNameToPropertiesMapping[this.beanIntrospection.propertyIndexOf((String)name)] = newPropertyIndex;
        } else {
            if (this.nameToPropertiesMapping == null) {
                this.nameToPropertiesMapping = new HashMap<String, Integer>();
            }
            this.nameToPropertiesMapping.put(name, newPropertyIndex);
        }
        if (addAliases && derProperty.aliases != null && derProperty.aliases.length > 0) {
            if (this.nameToPropertiesMapping == null) {
                this.nameToPropertiesMapping = new HashMap<String, Integer>();
            }
            for (String alias : derProperty.aliases) {
                this.nameToPropertiesMapping.put(alias, newPropertyIndex);
            }
        }
        this.properties.add(derProperty);
    }

    public void seal() {
        ((ArrayList)this.properties).trimToSize();
        this.properties = Collections.unmodifiableList(this.properties);
    }

    public List<Map.Entry<String, DeserBean.DerProperty<T, Object>>> getProperties() {
        Stream<AbstractMap.SimpleEntry> originalProperties = Arrays.stream(this.originalNameToPropertiesMapping).filter(index -> index != -1).mapToObj(index -> {
            DeserBean.DerProperty<T, Object> prop = this.properties.get(index);
            if (prop.beanProperty == null) {
                return null;
            }
            return new AbstractMap.SimpleEntry<String, DeserBean.DerProperty<T, Object>>(prop.beanProperty.getName(), prop);
        });
        Stream mappedByName = this.nameToPropertiesMapping == null ? Stream.empty() : this.nameToPropertiesMapping.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, DeserBean.DerProperty<T, Object>>((String)e.getKey(), this.properties.get((Integer)e.getValue())));
        return Stream.concat(originalProperties, mappedByName).collect(Collectors.toList());
    }

    public int propertyIndexOf(@NonNull String name) {
        int propertyIndex = -1;
        int beanPropertyIndex = this.beanIntrospection.propertyIndexOf(name);
        if (beanPropertyIndex != -1) {
            propertyIndex = this.originalNameToPropertiesMapping[beanPropertyIndex];
        }
        if (propertyIndex != -1) {
            return propertyIndex;
        }
        return this.nameToPropertiesMapping == null ? -1 : this.nameToPropertiesMapping.getOrDefault(name, -1);
    }

    public Consumer newConsumer() {
        return new Consumer();
    }

    public final class Consumer {
        private final BitSet consumedSet;
        private int remaining;

        public Consumer() {
            this.consumedSet = new BitSet(PropertiesBag.this.properties.size());
            this.remaining = PropertiesBag.this.properties.size();
        }

        public boolean isNotConsumed(String name) {
            int propertyIndex = PropertiesBag.this.propertyIndexOf(name);
            return propertyIndex != -1 && !this.consumedSet.get(propertyIndex);
        }

        public DeserBean.DerProperty<T, ?> findNotConsumed(String name) {
            int propertyIndex = PropertiesBag.this.propertyIndexOf(name);
            if (propertyIndex == -1 || this.consumedSet.get(propertyIndex)) {
                return null;
            }
            return PropertiesBag.this.properties.get(propertyIndex);
        }

        public DeserBean.DerProperty<T, ?> consume(String name) {
            int propertyIndex = PropertiesBag.this.propertyIndexOf(name);
            if (propertyIndex == -1 || this.consumedSet.get(propertyIndex)) {
                return null;
            }
            this.consumedSet.set(propertyIndex);
            --this.remaining;
            return PropertiesBag.this.properties.get(propertyIndex);
        }

        public List<DeserBean.DerProperty<T, Object>> getNotConsumed() {
            return IntStream.range(0, PropertiesBag.this.properties.size()).filter(index -> !this.consumedSet.get(index)).mapToObj(index -> PropertiesBag.this.properties.get(index)).collect(Collectors.toList());
        }

        public boolean isAllConsumed() {
            return this.remaining == 0;
        }
    }
}

