/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.UpdatingDeserializer;
import io.micronaut.serde.exceptions.InvalidFormatException;
import io.micronaut.serde.exceptions.InvalidPropertyFormatException;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.PropertiesBag;
import java.io.IOException;

final class SimpleObjectDeserializer
implements Deserializer<Object>,
UpdatingDeserializer<Object> {
    private final boolean ignoreUnknown;
    private final DeserBean<? super Object> deserBean;

    public SimpleObjectDeserializer(boolean ignoreUnknown, DeserBean<? super Object> deserBean) {
        this.ignoreUnknown = ignoreUnknown && deserBean.ignoreUnknown;
        this.deserBean = deserBean;
    }

    public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> beanType) throws IOException {
        Object obj;
        if (decoder.decodeNull()) {
            return null;
        }
        this.deserBean.initialize(decoderContext);
        try {
            obj = this.deserBean.introspection.instantiate();
        }
        catch (InstantiationException e) {
            throw new SerdeException("Unable to deserialize type [" + beanType + "]: " + e.getMessage(), (Throwable)e);
        }
        this.readProperties(decoder, decoderContext, beanType, obj);
        return obj;
    }

    public void deserializeInto(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> beanType, Object value) throws IOException {
        this.deserBean.initialize(decoderContext);
        this.readProperties(decoder, decoderContext, beanType, value);
    }

    private void readProperties(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> beanType, Object obj) throws IOException {
        Decoder objectDecoder = decoder.decodeObject(beanType);
        if (this.deserBean.readProperties == null) {
            this.skipUnknownProperties(objectDecoder, beanType);
        } else {
            String prop;
            PropertiesBag.Consumer readProperties = this.deserBean.readProperties.newConsumer();
            while ((prop = objectDecoder.decodeKey()) != null) {
                DeserBean.DerProperty consumedProperty = readProperties.consume(prop);
                if (consumedProperty != null) {
                    Object val;
                    boolean isNull = objectDecoder.decodeNull();
                    if (isNull) {
                        if (consumedProperty.nullable) {
                            consumedProperty.set(obj, null);
                            continue;
                        }
                        consumedProperty.setDefault(decoderContext, obj);
                        continue;
                    }
                    Argument argument = consumedProperty.argument;
                    try {
                        val = consumedProperty.deserializer.createSpecific(decoderContext, argument).deserialize(objectDecoder, decoderContext, argument);
                    }
                    catch (InvalidFormatException e) {
                        throw new InvalidPropertyFormatException(e, argument);
                    }
                    catch (Exception e) {
                        throw new SerdeException("Error decoding property [" + argument + "] of type [" + this.deserBean.introspection.getBeanType() + "]: " + e.getMessage(), (Throwable)e);
                    }
                    consumedProperty.set(obj, val);
                    if (!readProperties.isAllConsumed()) continue;
                    this.skipUnknownProperties(objectDecoder, beanType);
                    break;
                }
                this.skipUnknown(objectDecoder, beanType, prop);
            }
            if (!readProperties.isAllConsumed()) {
                for (DeserBean.DerProperty dp : readProperties.getNotConsumed()) {
                    dp.setDefault(decoderContext, obj);
                }
            }
        }
        objectDecoder.finishStructure();
    }

    private void skipUnknownProperties(Decoder decoder, Argument<? super Object> beanType) throws IOException {
        String unknownProp;
        while ((unknownProp = decoder.decodeKey()) != null) {
            this.skipUnknown(decoder, beanType, unknownProp);
        }
    }

    private void skipUnknown(Decoder decoder, Argument<? super Object> beanType, String prop) throws IOException {
        if (!this.ignoreUnknown) {
            throw new SerdeException("Unknown property [" + prop + "] encountered during deserialization of type: " + beanType);
        }
        decoder.skipValue();
    }

    public boolean allowNull() {
        return true;
    }
}

