/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.DeserBeanRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Internal
class SubtypedDeserBean<T>
extends DeserBean<T> {
    @NonNull
    public final Map<String, DeserBean<? extends T>> subtypes;
    @NonNull
    public final SerdeConfig.SerSubtyped.DiscriminatorType discriminatorType;
    @NonNull
    public final SerdeConfig.SerSubtyped.DiscriminatorValueKind discriminatorValue;
    @NonNull
    public final String discriminatorName;
    @Nullable
    public final String defaultImpl;

    SubtypedDeserBean(AnnotationMetadata annotationMetadata, BeanIntrospection<T> introspection, Deserializer.DecoderContext decoderContext, DeserBeanRegistry deserBeanRegistry) throws SerdeException {
        super(introspection, decoderContext, deserBeanRegistry);
        this.discriminatorType = annotationMetadata.enumValue(SerdeConfig.SerSubtyped.class, "dt", SerdeConfig.SerSubtyped.DiscriminatorType.class).orElse(SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY);
        this.discriminatorValue = annotationMetadata.enumValue(SerdeConfig.SerSubtyped.class, "dv", SerdeConfig.SerSubtyped.DiscriminatorValueKind.class).orElse(SerdeConfig.SerSubtyped.DiscriminatorValueKind.CLASS_NAME);
        this.discriminatorName = annotationMetadata.stringValue(SerdeConfig.SerSubtyped.class, "dp").orElse(this.discriminatorValue == SerdeConfig.SerSubtyped.DiscriminatorValueKind.CLASS_NAME ? "@class" : "@type");
        Class superType = introspection.getBeanType();
        Collection subtypeIntrospections = decoderContext.getDeserializableSubtypes(superType);
        this.subtypes = new HashMap<String, DeserBean<? extends T>>(subtypeIntrospections.size());
        Class defaultType = annotationMetadata.classValue(DefaultImplementation.class).orElse(null);
        String defaultDiscriminator = null;
        for (BeanIntrospection subtypeIntrospection : subtypeIntrospections) {
            String[] names;
            Class subBeanType = subtypeIntrospection.getBeanType();
            DeserBean deserBean = deserBeanRegistry.getDeserializableBean(Argument.of((Class)subBeanType), decoderContext);
            String discriminatorName = this.discriminatorValue == SerdeConfig.SerSubtyped.DiscriminatorValueKind.CLASS_NAME ? subBeanType.getName() : (this.discriminatorValue == SerdeConfig.SerSubtyped.DiscriminatorValueKind.CLASS_SIMPLE_NAME ? subBeanType.getSimpleName() : deserBean.introspection.stringValue(SerdeConfig.class, "typeName").orElse(deserBean.introspection.getBeanType().getSimpleName()));
            this.subtypes.put(discriminatorName, deserBean);
            if (defaultType != null && defaultType.equals(subBeanType)) {
                defaultDiscriminator = discriminatorName;
            }
            for (String name : names = subtypeIntrospection.stringValues(SerdeConfig.class, "typeNames")) {
                this.subtypes.put(name, deserBean);
            }
        }
        this.defaultImpl = defaultDiscriminator;
    }
}

