/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.exceptions.InvalidFormatException;
import io.micronaut.serde.support.serdes.FormattedTemporalSerde;
import io.micronaut.serde.support.serdes.TemporalSerde;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;

public abstract class DefaultFormattedTemporalSerde<T extends TemporalAccessor>
implements TemporalSerde<T> {
    private final FormattedTemporalSerde<T> defaultFormat;
    private final boolean treatDatesAsTimestamps;

    protected DefaultFormattedTemporalSerde(@NonNull SerdeConfiguration configuration) {
        this.defaultFormat = new FormattedTemporalSerde(this.getFormatter(configuration), this.query());
        this.treatDatesAsTimestamps = configuration.isWriteDatesAsTimestamps() && !configuration.getDateFormat().isPresent();
    }

    @NonNull
    protected abstract DateTimeFormatter getDefaultFormatter();

    public final void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        if (this.treatDatesAsTimestamps) {
            this.serializeWithoutFormat(encoder, context, value, type);
        } else {
            this.defaultFormat.serialize(encoder, context, type, (T)value);
        }
    }

    public final T deserializeNonNull(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super T> type) throws IOException {
        if (this.treatDatesAsTimestamps) {
            try {
                return this.deserializeNonNullWithoutFormat(decoder, decoderContext, type);
            }
            catch (InvalidFormatException invalidFormatException) {
                // empty catch block
            }
        }
        return (T)((TemporalAccessor)this.defaultFormat.deserialize(decoder, decoderContext, type));
    }

    protected abstract void serializeWithoutFormat(Encoder var1, Serializer.EncoderContext var2, T var3, Argument<? extends T> var4) throws IOException;

    protected abstract T deserializeNonNullWithoutFormat(Decoder var1, Deserializer.DecoderContext var2, Argument<? super T> var3) throws IOException;

    @NonNull
    private DateTimeFormatter getFormatter(@NonNull SerdeConfiguration configuration) {
        return this.createFormatter(configuration).orElseGet(this::getDefaultFormatter);
    }

    @NonNull
    private Optional<DateTimeFormatter> createFormatter(@NonNull SerdeConfiguration configuration) {
        return configuration.getDateFormat().map(pattern -> configuration.getLocale().map(locale -> DateTimeFormatter.ofPattern(pattern, locale)).orElseGet(() -> DateTimeFormatter.ofPattern(pattern))).map(formatter -> configuration.getTimeZone().map(tz -> formatter.withZone(tz.toZoneId())).orElse((DateTimeFormatter)formatter));
    }
}

