/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;

public class CustomizedObjectArrayDeserializer
implements Deserializer<Object[]> {
    private final Argument<Object> componentType;
    private final Deserializer<?> componentDeserializer;

    public CustomizedObjectArrayDeserializer(Argument<Object> componentType, Deserializer<?> deserializer) {
        this.componentType = componentType;
        this.componentDeserializer = deserializer;
    }

    public Object[] deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object[]> type) throws IOException {
        boolean decoderNotAllowsNull = !this.componentDeserializer.allowNull();
        Decoder arrayDecoder = decoder.decodeArray();
        Object[] buffer = (Object[])Array.newInstance(this.componentType.getType(), 50);
        int index = 0;
        while (arrayDecoder.hasNextArrayValue()) {
            int l = buffer.length;
            if (l == index) {
                buffer = Arrays.copyOf(buffer, l * 2);
            }
            if (decoderNotAllowsNull && arrayDecoder.decodeNull()) {
                ++index;
                continue;
            }
            buffer[index++] = this.componentDeserializer.deserialize(arrayDecoder, decoderContext, this.componentType);
        }
        arrayDecoder.finishStructure();
        return Arrays.copyOf(buffer, index);
    }
}

