/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.serdes.DefaultFormattedTemporalSerde;
import io.micronaut.serde.support.serdes.TemporalSerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQuery;

@Singleton
public class LocalDateTimeSerde
extends DefaultFormattedTemporalSerde<LocalDateTime>
implements TemporalSerde<LocalDateTime> {
    protected LocalDateTimeSerde(SerdeConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected DateTimeFormatter getDefaultFormatter() {
        return DateTimeFormatter.ISO_DATE_TIME;
    }

    @Override
    public TemporalQuery<LocalDateTime> query() {
        return LocalDateTime::from;
    }

    @Override
    protected void serializeWithoutFormat(Encoder encoder, Serializer.EncoderContext context, LocalDateTime value, Argument<? extends LocalDateTime> type) throws IOException {
        encoder.encodeString(this.getDefaultFormatter().format(value));
    }

    @Override
    protected LocalDateTime deserializeNonNullWithoutFormat(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super LocalDateTime> type) throws IOException {
        return this.getDefaultFormatter().parse((CharSequence)decoder.decodeString(), LocalDateTime::from);
    }
}

