/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.serdes.DefaultFormattedTemporalSerde;
import io.micronaut.serde.support.serdes.TemporalSerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQuery;

@Singleton
public class OffsetDateTimeSerde
extends DefaultFormattedTemporalSerde<OffsetDateTime> {
    protected OffsetDateTimeSerde(SerdeConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected DateTimeFormatter getDefaultFormatter() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    }

    @Override
    public TemporalQuery<OffsetDateTime> query() {
        return OffsetDateTime::from;
    }

    @Override
    protected void serializeWithoutFormat(Encoder encoder, Serializer.EncoderContext context, OffsetDateTime value, Argument<? extends OffsetDateTime> type) throws IOException {
        encoder.encodeLong(value.withOffsetSameInstant(ZoneOffset.UTC).toInstant().toEpochMilli());
    }

    @Override
    protected OffsetDateTime deserializeNonNullWithoutFormat(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super OffsetDateTime> type) throws IOException {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(decoder.decodeLong()), TemporalSerde.UTC);
    }
}

