/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.serde.support.deserializers.DeserBean;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class PropertiesBag<T> {
    private final BeanIntrospection<T> beanIntrospection;
    private final int[] originalNameToPropertiesMapping;
    private final DeserBean.DerProperty<T, Object>[] properties;
    @Nullable
    private final Map<String, Integer> nameToPropertiesMapping;

    private PropertiesBag(BeanIntrospection<T> beanIntrospection, int[] originalNameToPropertiesMapping, DeserBean.DerProperty<T, Object>[] properties, Map<String, Integer> nameToPropertiesMapping) {
        this.beanIntrospection = beanIntrospection;
        this.originalNameToPropertiesMapping = originalNameToPropertiesMapping;
        this.properties = properties;
        this.nameToPropertiesMapping = nameToPropertiesMapping;
    }

    public List<Map.Entry<String, DeserBean.DerProperty<T, Object>>> getProperties() {
        Stream<AbstractMap.SimpleEntry> originalProperties = Arrays.stream(this.originalNameToPropertiesMapping).filter(index -> index != -1).mapToObj(index -> {
            DeserBean.DerProperty<T, Object> prop = this.properties[index];
            if (prop.beanProperty == null) {
                return null;
            }
            return new AbstractMap.SimpleEntry<String, DeserBean.DerProperty<T, Object>>(prop.beanProperty.getName(), prop);
        });
        Stream mappedByName = this.nameToPropertiesMapping == null ? Stream.empty() : this.nameToPropertiesMapping.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, DeserBean.DerProperty<T, Object>>((String)e.getKey(), this.properties[(Integer)e.getValue()]));
        return Stream.concat(originalProperties, mappedByName).collect(Collectors.toList());
    }

    public int propertyIndexOf(@NonNull String name) {
        int propertyIndex = -1;
        int beanPropertyIndex = this.beanIntrospection.propertyIndexOf(name);
        if (beanPropertyIndex != -1) {
            propertyIndex = this.originalNameToPropertiesMapping[beanPropertyIndex];
        }
        if (propertyIndex != -1) {
            return propertyIndex;
        }
        return this.nameToPropertiesMapping == null ? -1 : this.nameToPropertiesMapping.getOrDefault(name, -1);
    }

    public Consumer newConsumer() {
        return new Consumer();
    }

    public final class Consumer {
        private final boolean[] consumed;
        private int remaining;

        public Consumer() {
            this.consumed = new boolean[PropertiesBag.this.properties.length];
            this.remaining = PropertiesBag.this.properties.length;
        }

        public boolean isNotConsumed(String name) {
            int propertyIndex = PropertiesBag.this.propertyIndexOf(name);
            return propertyIndex != -1 && !this.consumed[propertyIndex];
        }

        public DeserBean.DerProperty<T, Object> findNotConsumed(String name) {
            int propertyIndex = PropertiesBag.this.propertyIndexOf(name);
            if (propertyIndex == -1 || this.consumed[propertyIndex]) {
                return null;
            }
            return PropertiesBag.this.properties[propertyIndex];
        }

        public DeserBean.DerProperty<T, Object> consume(String name) {
            int propertyIndex = PropertiesBag.this.propertyIndexOf(name);
            if (propertyIndex == -1 || this.consumed[propertyIndex]) {
                return null;
            }
            this.consumed[propertyIndex] = true;
            --this.remaining;
            return PropertiesBag.this.properties[propertyIndex];
        }

        public List<DeserBean.DerProperty<T, Object>> getNotConsumed() {
            ArrayList list = new ArrayList(PropertiesBag.this.properties.length);
            int bound = PropertiesBag.this.properties.length;
            for (int index = 0; index < bound; ++index) {
                if (this.consumed[index]) continue;
                list.add(PropertiesBag.this.properties[index]);
            }
            return list;
        }

        public boolean isAllConsumed() {
            return this.remaining == 0;
        }
    }

    public static class Builder<T> {
        private final BeanIntrospection<T> beanIntrospection;
        private final int[] originalNameToPropertiesMapping;
        @Nullable
        private Map<String, Integer> nameToPropertiesMapping;
        private final List<DeserBean.DerProperty<T, Object>> mutableProperties;

        public Builder(BeanIntrospection<T> beanIntrospection) {
            this(beanIntrospection, beanIntrospection.getBeanProperties().size());
        }

        public Builder(BeanIntrospection<T> beanIntrospection, int expectedPropertiesSize) {
            this.beanIntrospection = beanIntrospection;
            int beanPropertiesSize = beanIntrospection.getBeanProperties().size();
            this.originalNameToPropertiesMapping = new int[beanPropertiesSize];
            Arrays.fill(this.originalNameToPropertiesMapping, -1);
            this.mutableProperties = new ArrayList<DeserBean.DerProperty<T, Object>>(expectedPropertiesSize);
        }

        public void register(String name, DeserBean.DerProperty<T, Object> derProperty, boolean addAliases) {
            int newPropertyIndex = this.mutableProperties.size();
            if (derProperty.beanProperty != null && derProperty.beanProperty.getDeclaringBean() == this.beanIntrospection && name.equals(derProperty.beanProperty.getName())) {
                this.originalNameToPropertiesMapping[this.beanIntrospection.propertyIndexOf((String)name)] = newPropertyIndex;
            } else {
                if (this.nameToPropertiesMapping == null) {
                    this.nameToPropertiesMapping = new HashMap<String, Integer>();
                }
                this.nameToPropertiesMapping.put(name, newPropertyIndex);
            }
            if (addAliases && derProperty.aliases != null && derProperty.aliases.length > 0) {
                if (this.nameToPropertiesMapping == null) {
                    this.nameToPropertiesMapping = new HashMap<String, Integer>();
                }
                for (String alias : derProperty.aliases) {
                    this.nameToPropertiesMapping.put(alias, newPropertyIndex);
                }
            }
            this.mutableProperties.add(derProperty);
        }

        @Nullable
        public PropertiesBag<T> build() {
            if (this.mutableProperties.isEmpty()) {
                return null;
            }
            return new PropertiesBag<T>(this.beanIntrospection, this.originalNameToPropertiesMapping, (DeserBean.DerProperty[])this.mutableProperties.toArray(DeserBean.DerProperty[]::new), this.nameToPropertiesMapping);
        }
    }
}

