/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import java.io.IOException;
import java.util.ArrayList;

final class StringListDeserializer
implements Deserializer<ArrayList<String>> {
    static final StringListDeserializer INSTANCE = new StringListDeserializer();

    private StringListDeserializer() {
    }

    public ArrayList<String> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super ArrayList<String>> type) throws IOException {
        Decoder arrayDecoder = decoder.decodeArray();
        ArrayList<String> collection = new ArrayList<String>();
        while (arrayDecoder.hasNextArrayValue()) {
            if (arrayDecoder.decodeNull()) {
                collection.add(null);
                continue;
            }
            collection.add(arrayDecoder.decodeString());
        }
        arrayDecoder.finishStructure();
        return collection;
    }

    public ArrayList<String> getDefaultValue(Deserializer.DecoderContext context, Argument<? super ArrayList<String>> type) {
        return new ArrayList<String>();
    }
}

