/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.config.DeserializationConfiguration;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.DeserBeanRegistry;
import io.micronaut.serde.support.deserializers.SimpleObjectDeserializer;
import io.micronaut.serde.support.deserializers.SimpleRecordLikeObjectDeserializer;
import io.micronaut.serde.support.deserializers.SpecificObjectDeserializer;
import io.micronaut.serde.support.deserializers.SubtypedDeserBean;
import io.micronaut.serde.support.util.TypeKey;
import io.micronaut.serde.util.CustomizableDeserializer;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
@Primary
@BootstrapContextCompatible
public class ObjectDeserializer
implements CustomizableDeserializer<Object>,
DeserBeanRegistry {
    private final SerdeIntrospections introspections;
    private final boolean ignoreUnknown;
    private final Map<TypeKey, DeserBean<? super Object>> deserBeanMap = new ConcurrentHashMap<TypeKey, DeserBean<? super Object>>(50);

    public ObjectDeserializer(SerdeIntrospections introspections, DeserializationConfiguration deserializationConfiguration) {
        this.introspections = introspections;
        this.ignoreUnknown = deserializationConfiguration.isIgnoreUnknown();
    }

    public Deserializer<Object> createSpecific(Deserializer.DecoderContext context, Argument<? super Object> type) throws SerdeException {
        if (type.equalsType(Argument.OBJECT_ARGUMENT)) {
            return (decoder, context1, type1) -> decoder.decodeArbitrary();
        }
        DeserBean<? super Object> deserBean = this.getDeserializableBean(type, context);
        if (deserBean.simpleBean) {
            return new SimpleObjectDeserializer(this.ignoreUnknown, deserBean);
        }
        if (deserBean.recordLikeBean) {
            return new SimpleRecordLikeObjectDeserializer(this.ignoreUnknown, deserBean);
        }
        return new SpecificObjectDeserializer(this.ignoreUnknown, deserBean);
    }

    @Override
    public <T> DeserBean<T> getDeserializableBean(Argument<T> type, Deserializer.DecoderContext decoderContext) throws SerdeException {
        TypeKey key = new TypeKey(type);
        DeserBean<Object> deserBeanSupplier = this.deserBeanMap.get(key);
        if (deserBeanSupplier == null) {
            deserBeanSupplier = this.createDeserBean(type, decoderContext);
            this.deserBeanMap.put(key, deserBeanSupplier);
            deserBeanSupplier.initialize(decoderContext);
        }
        return deserBeanSupplier;
    }

    private <T> DeserBean<T> createDeserBean(Argument<T> type, Deserializer.DecoderContext decoderContext) {
        try {
            BeanIntrospection deserializableIntrospection = this.introspections.getDeserializableIntrospection(type);
            AnnotationMetadataHierarchy annotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{type.getAnnotationMetadata(), deserializableIntrospection.getAnnotationMetadata()});
            if (annotationMetadata.hasAnnotation(SerdeConfig.SerSubtyped.class)) {
                if (type.hasTypeVariables()) {
                    final Map bounds = type.getTypeVariables();
                    return new SubtypedDeserBean((AnnotationMetadata)annotationMetadata, deserializableIntrospection, decoderContext, this){

                        @Override
                        protected Map<String, Argument<?>> getBounds() {
                            return bounds;
                        }
                    };
                }
                return new SubtypedDeserBean((AnnotationMetadata)annotationMetadata, deserializableIntrospection, decoderContext, this);
            }
            if (type.hasTypeVariables()) {
                final Map bounds = type.getTypeVariables();
                return new DeserBean(deserializableIntrospection, decoderContext, this){

                    @Override
                    protected Map<String, Argument<?>> getBounds() {
                        return bounds;
                    }
                };
            }
            return new DeserBean(deserializableIntrospection, decoderContext, this);
        }
        catch (SerdeException e) {
            throw new IntrospectionException("Error creating deserializer for type [" + type + "]: " + e.getMessage(), (Throwable)e);
        }
    }
}

