/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.json.convert.JsonNodeConvertibleValues;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Optional;

@Singleton
final class ConvertibleValuesDeserializer
implements Deserializer<ConvertibleValues> {
    @NonNull
    private final ConversionService conversionService;

    ConvertibleValuesDeserializer(@NonNull ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @NonNull
    public Deserializer<ConvertibleValues> createSpecific(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super ConvertibleValues> type) throws SerdeException {
        Optional var = type.getFirstTypeVariable();
        if (var.isPresent()) {
            return new Specialized((Argument<Object>)((Argument)var.get()), (Deserializer<Object>)context.findDeserializer((Argument)var.get()));
        }
        return this;
    }

    public ConvertibleValues deserialize(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super ConvertibleValues> type) throws IOException {
        JsonNode node = decoder.decodeNode();
        if (!node.isObject()) {
            throw decoder.createDeserializationException("Expected object", (Object)node);
        }
        return new JsonNodeConvertibleValues(node, this.conversionService);
    }

    private class Specialized
    implements Deserializer<ConvertibleValues> {
        @Nullable
        private final Argument<Object> componentType;
        @Nullable
        private final Deserializer<Object> componentDeserializer;

        Specialized(@Nullable Argument<Object> componentType, Deserializer<Object> componentDeserializer) {
            this.componentType = componentType;
            this.componentDeserializer = componentDeserializer;
        }

        @Nullable
        public ConvertibleValues deserialize(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super ConvertibleValues> type) throws IOException {
            String key;
            Decoder obj = decoder.decodeObject(type);
            MutableConvertibleValuesMap map = new MutableConvertibleValuesMap();
            map.setConversionService(ConvertibleValuesDeserializer.this.conversionService);
            while ((key = obj.decodeKey()) != null) {
                map.put((CharSequence)key, this.componentDeserializer.deserialize(decoder, context, this.componentType));
            }
            obj.finishStructure();
            return map;
        }
    }
}

