/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.UpdatingDeserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.PropertiesBag;
import java.io.IOException;

final class SimpleRecordLikeObjectDeserializer
implements Deserializer<Object>,
UpdatingDeserializer<Object> {
    private final BeanIntrospection<Object> introspection;
    private final PropertiesBag<Object> constructorParameters;
    private final int valuesSize;
    private final boolean ignoreUnknown;

    SimpleRecordLikeObjectDeserializer(boolean ignoreUnknown, DeserBean<? super Object> deserBean) {
        this.introspection = deserBean.introspection;
        this.constructorParameters = deserBean.creatorParams;
        this.valuesSize = deserBean.creatorSize;
        this.ignoreUnknown = ignoreUnknown && deserBean.ignoreUnknown;
    }

    public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> beanType) throws IOException {
        Object obj;
        Object propertyName;
        boolean allConsumed;
        Decoder objectDecoder = decoder.decodeObject(beanType);
        PropertiesBag.Consumer creatorParameters = this.constructorParameters.newConsumer();
        Object[] params = new Object[this.valuesSize];
        boolean bl = allConsumed = this.valuesSize == 0;
        while (!allConsumed && (propertyName = objectDecoder.decodeKey()) != null) {
            DeserBean.DerProperty derProperty = creatorParameters.consume((String)propertyName);
            if (derProperty != null) {
                derProperty.deserializeAndSetConstructorValue(objectDecoder, decoderContext, params);
                allConsumed = creatorParameters.isAllConsumed();
                continue;
            }
            if (this.ignoreUnknown) {
                objectDecoder.skipValue();
                continue;
            }
            return new SerdeException("Unknown property [" + (String)propertyName + "] encountered during deserialization of type: " + beanType);
        }
        if (!allConsumed) {
            for (DeserBean.DerProperty derProperty : creatorParameters.getNotConsumed()) {
                derProperty.setDefaultConstructorValue(decoderContext, params);
            }
        }
        try {
            obj = this.introspection.instantiate(params);
        }
        catch (InstantiationException instantiationException) {
            throw new SerdeException("Unable to deserialize type [" + beanType + "]: " + instantiationException.getMessage(), (Throwable)instantiationException);
        }
        objectDecoder.finishStructure(true);
        return obj;
    }

    public Object deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Object> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type);
    }

    public void deserializeInto(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> beanType, Object value) throws IOException {
        throw new SerdeException("Unsupported deserialize into for [" + beanType + "]");
    }
}

